/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.viewpoints.configuration.ChildRule;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.provider.RuleItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildRuleItemProvider
extends RuleItemProvider {
    public ChildRuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addElementPropertyDescriptor(object);
            this.addStereotypesPropertyDescriptor(object);
            this.addOriginPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addElementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_element_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ChildRule_element_feature", "_UI_ChildRule_type"), (EStructuralFeature)ConfigurationPackage.Literals.CHILD_RULE__ELEMENT, true, false, true, null, null, null));
    }

    protected void addStereotypesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_stereotypes_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ChildRule_stereotypes_feature", "_UI_ChildRule_type"), (EStructuralFeature)ConfigurationPackage.Literals.CHILD_RULE__STEREOTYPES, true, false, true, null, null, null));
    }

    protected void addOriginPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ChildRule_origin_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ChildRule_origin_feature", "_UI_ChildRule_type"), (EStructuralFeature)ConfigurationPackage.Literals.CHILD_RULE__ORIGIN, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ConfigurationPackage.Literals.CHILD_RULE__INSERTION_PATH);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ChildRule.png"));
    }

    @Override
    public String getText(Object object) {
        ChildRule rule = (ChildRule)object;
        StringBuilder builder = new StringBuilder("[");
        builder.append(rule.getOrigin() != null ? rule.getOrigin().getName() : "#");
        builder.append("] add: ");
        if (!rule.getStereotypes().isEmpty()) {
            builder.append("<<");
            int i = 0;
            while (i != rule.getStereotypes().size()) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(((EClass)rule.getStereotypes().get(i)).getName());
                ++i;
            }
            builder.append(">> ");
        }
        builder.append(rule.getElement() != null ? rule.getElement().getName() : "#");
        builder.append(" => ");
        builder.append(rule.isPermit() ? "allow" : "deny");
        return builder.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ChildRule.class)) {
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ConfigurationPackage.Literals.CHILD_RULE__INSERTION_PATH, ConfigurationFactory.eINSTANCE.createPathElement()));
    }
}

