/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.papyrus.infra.tools.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderHelper {
    private static final Map<String, Class<?>> classes = new HashMap();

    public static Class<?> loadClass(String className) {
        try {
            Class result = classes.get(className);
            if (result == null) {
                result = Activator.getDefault().getBundle().loadClass(className);
                classes.put(className, result);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            Activator.log.error(String.format("The class %s doesn't exist", className), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            Activator.log.error("Cannot load class " + className, (Throwable)ex);
        }
        return null;
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> asSubClass) {
        Class<?> theClass = ClassLoaderHelper.loadClass(className);
        if (theClass == null) {
            return null;
        }
        try {
            Class<T> typedClass = theClass.asSubclass(asSubClass);
            return typedClass;
        }
        catch (ClassCastException ex) {
            Activator.log.error(String.format("The class %1$s doesn't extend or implement %2$s", className, asSubClass.getName()), (Throwable)ex);
            return null;
        }
    }

    public static <T> T newInstance(String className, Class<T> asSubclass) {
        Class<T> typedClass = ClassLoaderHelper.loadClass(className, asSubclass);
        if (typedClass == null) {
            return null;
        }
        return ClassLoaderHelper.newInstance(typedClass);
    }

    public static Object newInstance(String className) {
        return ClassLoaderHelper.newInstance(ClassLoaderHelper.loadClass(className));
    }

    public static <T> T newInstance(Class<T> theClass) {
        if (theClass == null) {
            return null;
        }
        try {
            return theClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            Activator.log.error("Cannot find a valid public constructor for the class " + theClass.getName(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            Activator.log.error(String.format("The class %s cannot be instantiated.", theClass.getName()), (Throwable)ex);
        }
        return null;
    }
}

