/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.views.result;

import org.eclipse.acceleo.internal.ide.ui.views.result.AcceleoResultView;
import org.eclipse.acceleo.internal.ide.ui.views.result.TraceabilityTargetFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class AcceleoResultFilesFilter
extends ViewerFilter {
    private AcceleoResultView view;

    public AcceleoResultFilesFilter(AcceleoResultView view) {
        this.view = view;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof String) {
            return true;
        }
        Object resource = element;
        if (resource instanceof IJavaProject) {
            resource = ((IJavaProject)resource).getProject();
        }
        return !(resource instanceof IResource) || this.select((IResource)resource);
    }

    private boolean select(IResource resource) {
        if (this.view.getContent() != null) {
            IPath path = resource.getFullPath();
            TraceabilityTargetFile[] traceabilityTargetFileArray = this.view.getContent().getTargetFiles();
            int n = traceabilityTargetFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TraceabilityTargetFile targetFile = traceabilityTargetFileArray[n2];
                if (path.isPrefixOf(targetFile.getTargetFileFullPath())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

