/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.generators;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.common.internal.utils.workspace.AcceleoWorkspaceUtil;
import org.eclipse.acceleo.common.internal.utils.workspace.BundleURLConverter;
import org.eclipse.acceleo.common.preference.AcceleoPreferences;
import org.eclipse.acceleo.engine.generation.strategy.DefaultStrategy;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.service.AcceleoModulePropertiesAdapter;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoMainClass;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoModule;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoPom;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.acceleowizardmodel.AcceleowizardmodelPackage;
import org.eclipse.acceleo.internal.ide.ui.resource.AcceleoUIResourceSet;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoUIGenerator {
    private static Module buildAcceleoGenerator;
    private static Module acceleoJavaClassGenerator;
    private static Module antRunnerGenerator;
    private static Module antTargetGenerator;
    private static Module moduleGenerator;
    private static Module projectSettings;
    private static Module projectClasspath;
    private static Module projectManifest;
    private static Module buildProperties;
    private static Module buildXML;
    private static Module activator;
    private static Module pom;
    private static Module pomChild;
    private static Module acceleoCompiler;
    private static Module dotProject;
    private static Module pomFeature;
    private static Module pomUpdateSite;
    private static AcceleoUIGenerator instance;

    private AcceleoUIGenerator() {
    }

    public static AcceleoUIGenerator getDefault() {
        if (instance == null) {
            instance = new AcceleoUIGenerator();
        }
        return instance;
    }

    public void generateJavaClass(AcceleoMainClass acceleoMainClass, IContainer outputContainer) {
        this.generate(acceleoJavaClassGenerator, acceleoMainClass, outputContainer, "acceleoJavaClassGenerator.emtl", "genAbstractAcceleoGenerator");
    }

    public void generateAntFiles(AcceleoMainClass acceleoMainClass, String eclipseFilePath, String workspaceFilePath, IContainer outputContainer) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(eclipseFilePath);
        args.add(workspaceFilePath);
        this.generate(antRunnerGenerator, acceleoMainClass, outputContainer, "antRunner.emtl", "genAntRunner", args);
        this.generate(antTargetGenerator, acceleoMainClass, outputContainer, "antRunnerTarget.emtl", "genAntRunnerTarget", args);
    }

    @Deprecated
    public void generateBuildAcceleo(AcceleoProject acceleoProject, IContainer outputContainer) {
    }

    public void generateAcceleoModule(AcceleoModule acceleoModule, IContainer outputContainer) {
        this.generate(moduleGenerator, acceleoModule, outputContainer, "acceleoModule.emtl", "genAcceleoModule");
    }

    public void generateProjectSettings(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(projectSettings, acceleoProject, outputContainer, "projectSettings.emtl", "genProjectSettings");
    }

    public void generateProjectClasspath(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(projectClasspath, acceleoProject, outputContainer, "projectClasspath.emtl", "genProjectClassPath");
    }

    public void generateProjectManifest(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(projectManifest, acceleoProject, outputContainer, "projectManifest.emtl", "genManifestMF");
    }

    public void generateBuildProperties(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(buildProperties, acceleoProject, outputContainer, "buildProperties.emtl", "genBuildProperties");
    }

    public void generateBuildXML(AcceleoMainClass acceleoMainClass, String eclipseFilePath, String workspaceFilePath, IContainer outputContainer) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(eclipseFilePath);
        args.add(workspaceFilePath);
        this.generate(buildXML, acceleoMainClass, outputContainer, "antCompiler.emtl", "genAntCompiler", args);
    }

    public void generateActivator(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(activator, acceleoProject, outputContainer, "activator.emtl", "genActivator");
    }

    public void generatePom(AcceleoPom acceleoPom, IContainer outputContainer, String parentName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(parentName);
        this.generate(pom, acceleoPom, outputContainer, "pom.emtl", "genPom", args);
    }

    public void generateDotProject(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(dotProject, acceleoProject, outputContainer, "dotProject.emtl", "generateElement");
    }

    public void generatePomChild(AcceleoPom acceleoPom, IContainer outputContainer, String parentName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(parentName);
        this.generate(pomChild, acceleoPom, outputContainer, "pomChild.emtl", "genPom", args);
    }

    public void generateAcceleoCompiler(AcceleoProject acceleoProject, IContainer outputContainer) {
        this.generate(acceleoCompiler, acceleoProject, outputContainer, "acceleoCompiler.emtl", "generateElement");
    }

    public void generatePomFeature(AcceleoPom acceleoPom, IContainer outputContainer, String parentName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(parentName);
        this.generate(pomFeature, acceleoPom, outputContainer, "pomFeature.emtl", "genPomFeature", args);
    }

    public void generatePomUpdateSite(AcceleoPom acceleoPom, IContainer outputContainer, String parentName) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(parentName);
        this.generate(pomUpdateSite, acceleoPom, outputContainer, "pomUpdateSite.emtl", "genPomUpdateSite", args);
    }

    private void generate(Module module, EObject eObject, IContainer outputContainer, String generatorURI, String templateURI) {
        Module moduleTmp = module;
        try {
            if (moduleTmp == null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                this.registerPackages((ResourceSet)resourceSet);
                this.registerResourceFactories((ResourceSet)resourceSet);
                resourceSet.setURIConverter(this.createURIConverter());
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                URI moduleURI = this.convertToURI(generatorURI);
                EObject load = AcceleoUIResourceSet.getResource(moduleURI);
                if (load instanceof Module) {
                    moduleTmp = (Module)load;
                }
            }
            if (moduleTmp != null) {
                AcceleoModulePropertiesAdapter adapter = new AcceleoModulePropertiesAdapter();
                adapter.addProperty("DISABLE_DYNAMIC_MODULES");
                moduleTmp.eAdapters().add((Object)adapter);
                String templateName = templateURI;
                File generationRoot = outputContainer.getLocation().toFile();
                boolean traceabilityEnabled = AcceleoPreferences.isTraceabilityEnabled();
                if (traceabilityEnabled) {
                    AcceleoPreferences.switchTraceability((boolean)false);
                }
                new AcceleoService((IAcceleoGenerationStrategy)new DefaultStrategy()).doGenerate(moduleTmp, templateName, eObject, generationRoot, true, (Monitor)new BasicMonitor());
                outputContainer.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                if (traceabilityEnabled) {
                    AcceleoPreferences.switchTraceability((boolean)true);
                }
            }
        }
        catch (IOException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    private void generate(Module module, EObject eObject, IContainer outputContainer, String generatorURI, String templateURI, List<? extends Object> args) {
        Module moduleTmp = module;
        try {
            if (moduleTmp == null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                this.registerPackages((ResourceSet)resourceSet);
                this.registerResourceFactories((ResourceSet)resourceSet);
                resourceSet.setURIConverter(this.createURIConverter());
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                URI moduleURI = this.convertToURI(generatorURI);
                EObject load = AcceleoUIResourceSet.getResource(moduleURI);
                if (load instanceof Module) {
                    moduleTmp = (Module)load;
                }
            }
            if (moduleTmp != null) {
                AcceleoModulePropertiesAdapter adapter = new AcceleoModulePropertiesAdapter();
                adapter.addProperty("DISABLE_DYNAMIC_MODULES");
                moduleTmp.eAdapters().add((Object)adapter);
                boolean traceabilityEnabled = AcceleoPreferences.isTraceabilityEnabled();
                if (traceabilityEnabled) {
                    AcceleoPreferences.switchTraceability((boolean)false);
                }
                String templateName = templateURI;
                File generationRoot = outputContainer.getLocation().toFile();
                new AcceleoService((IAcceleoGenerationStrategy)new DefaultStrategy()).doGenerate(moduleTmp, templateName, eObject, args, generationRoot, true, (Monitor)new BasicMonitor());
                outputContainer.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                if (traceabilityEnabled) {
                    AcceleoPreferences.switchTraceability((boolean)true);
                }
            }
        }
        catch (IOException e) {
            AcceleoUIActivator.log(e, true);
        }
        catch (CoreException e) {
            AcceleoUIActivator.log((Exception)((Object)e), true);
        }
    }

    protected URIConverter createURIConverter() {
        return new ExtensibleURIConverterImpl(){

            public URI normalize(URI uri) {
                BundleURLConverter conv;
                URI normalized = (URI)this.getURIMap().get(uri);
                if (normalized == null && (conv = new BundleURLConverter(uri.toString())).resolveBundle() != null) {
                    normalized = URI.createURI((String)conv.resolveAsPlatformPlugin());
                    this.getURIMap().put(uri, normalized);
                }
                if (normalized != null) {
                    return normalized;
                }
                return super.normalize(uri);
            }
        };
    }

    private URI convertToURI(String moduleURI) {
        URL url = this.convertModuleURI(moduleURI);
        return this.createTemplateURI(url.toString());
    }

    private URL convertModuleURI(String moduleURI) {
        URL moduleURL = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            try {
                moduleURL = AcceleoWorkspaceUtil.getResourceURL(this.getClass(), (String)moduleURI);
            }
            catch (IOException iOException) {}
        }
        if (moduleURL == null) {
            moduleURL = this.getClass().getResource(moduleURI);
        }
        return moduleURL;
    }

    private URI createTemplateURI(String entry) {
        if (entry.startsWith("file:") || entry.startsWith("jar:")) {
            return URI.createURI((String)URI.decode((String)entry), (boolean)false);
        }
        return URI.createFileURI((String)URI.decode((String)entry));
    }

    private void registerPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)org.eclipse.ocl.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.ocl.ecore.EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)this.getOCLStdLibPackage());
        resourceSet.getPackageRegistry().put((Object)AcceleowizardmodelPackage.eINSTANCE.getNsURI(), (Object)AcceleowizardmodelPackage.eINSTANCE);
    }

    private EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }

    private void registerResourceFactories(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlResourceFactoryImpl());
    }
}

