/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceEntry;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferenceSorter;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.references.ReferencesTreeContentProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;

public class ReferencesSearchViewPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
        }
    };
    private ReferencesTreeContentProvider treeContentProvider;

    public ReferencesSearchViewPage() {
        super(2);
    }

    protected void clear() {
        if (this.treeContentProvider != null) {
            this.treeContentProvider.clear();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setSorter((ViewerSorter)new ReferenceSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new ReferenceLabelProvider());
        this.treeContentProvider = new ReferencesTreeContentProvider(viewer);
        viewer.setContentProvider((IContentProvider)this.treeContentProvider);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.treeContentProvider != null) {
            this.treeContentProvider.elementsChanged(objects);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) {
        URI fileURI;
        ReferenceEntry entry = (ReferenceEntry)match.getElement();
        EObject eObject = entry.getMatch();
        if (eObject.eResource() != null) {
            fileURI = eObject.eResource().getURI();
        } else if (entry.getTemplateFile() != null) {
            AcceleoProject acceleoProject = new AcceleoProject(entry.getTemplateFile().getProject());
            fileURI = URI.createPlatformResourceURI((String)acceleoProject.getOutputFilePath(entry.getTemplateFile()).toString(), (boolean)false);
        } else {
            fileURI = null;
        }
        if (fileURI != null) {
            IFile moduleFile = entry.getTemplateFile();
            try {
                IDE.openEditor((IWorkbenchPage)this.getSite().getPage(), (IFile)moduleFile);
                OpenDeclarationUtils.showEObject(this.getSite().getPage(), fileURI, (IRegion)new Region(currentOffset, currentLength), eObject);
            }
            catch (PartInitException e) {
                AcceleoUIActivator.log((Exception)((Object)e), false);
            }
        }
    }
}

