/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ocl.ecore.LiteralExp;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoRenameTextRefactoring
extends Refactoring {
    private static final String ORIGINAL_TEXT = "original_text";
    private static final String NEWNAME = "newName";
    private final String title = AcceleoUIMessages.getString("AcceleoEditorRenameVariableRefactoring.RenameTextTitle");
    private final String invalidText = AcceleoUIMessages.getString("AcceleoEditorRenameTextRefactoring.NoTextSpecified");
    private ModuleElement parent;
    private AcceleoSourceContent acceleoSourceContent;
    private ITextSelection textSelection;
    private String newName;
    private TextFileChange textFileChange;

    public String getName() {
        return this.title;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.textSelection == null || this.textSelection.getText() == null || this.textSelection.getText().length() == 0) {
            return RefactoringStatus.createErrorStatus((String)this.invalidText);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (this.newName == null) {
            status.merge(RefactoringStatus.createErrorStatus((String)this.invalidText));
        }
        this.computeChange();
        return status;
    }

    private void computeChange() {
        this.textFileChange = new TextFileChange(this.title, this.acceleoSourceContent.getFile());
        MultiTextEdit edit = new MultiTextEdit();
        this.textFileChange.setEdit((TextEdit)edit);
        this.textFileChange.setTextType("mtl");
        String text = this.textSelection.getText();
        if (this.parent instanceof Template) {
            Template template = (Template)this.parent;
            List<OCLExpression> body = this.getContainedOCLExpression((Block)template);
            for (OCLExpression templateExpression : body) {
                if (!(templateExpression instanceof LiteralExp)) continue;
                LiteralExp textExpression = (LiteralExp)templateExpression;
                int end = textExpression.getEndPosition();
                int index = textExpression.toString().indexOf(text);
                while (index != -1 && index <= end) {
                    edit.addChild((TextEdit)new ReplaceEdit(textExpression.getStartPosition() + index - 1, this.textSelection.getLength(), this.newName));
                    index = textExpression.toString().indexOf(text, index + 1);
                }
            }
        }
    }

    private List<OCLExpression> getContainedOCLExpression(Block block) {
        EList body = block.getBody();
        if (body == null || body.size() == 0) {
            return null;
        }
        ArrayList<OCLExpression> subBody = new ArrayList<OCLExpression>();
        for (OCLExpression oclExpression : body) {
            if (!(oclExpression instanceof Block)) continue;
            subBody.addAll(this.getContainedOCLExpression((Block)oclExpression));
        }
        body.addAll(subBody);
        return body;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.textFileChange;
    }

    public void setSourceContent(AcceleoSourceContent content) {
        this.acceleoSourceContent = content;
    }

    public void setParent(ModuleElement moduleElement) {
        this.parent = moduleElement;
    }

    public RefactoringStatus initialize(Map<String, String> arguments) {
        RefactoringStatus status = new RefactoringStatus();
        String value = arguments.get(ORIGINAL_TEXT);
        value = arguments.get(NEWNAME);
        if (value != null) {
            this.setNewName(value);
        }
        return status;
    }

    public RefactoringStatus setNewName(String text) {
        if (text == null || text.length() == 0) {
            return RefactoringStatus.createErrorStatus((String)this.invalidText);
        }
        this.newName = text;
        return new RefactoringStatus();
    }

    public String getText() {
        return this.textSelection.getText();
    }

    public void setSelection(ITextSelection selection) {
        this.textSelection = selection;
    }
}

