/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLockedRequest
extends CDOClientRequest<Boolean> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ObjectLockedRequest.class);
    private CDOView view;
    private CDOObject object;
    private IRWLockManager.LockType lockType;
    private boolean byOthers;

    public ObjectLockedRequest(CDOClientProtocol protocol, CDOView view, CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        super(protocol, (short)26);
        this.view = view;
        this.object = object;
        this.lockType = lockType;
        this.byOthers = byOthers;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        if (TRACER.isEnabled()) {
            TRACER.format("Requesting if object {0} has  of lock for object {1}", new Object[]{this.object.cdoID(), this.lockType == IRWLockManager.LockType.READ ? "read" : "write"});
        }
        out.writeInt(this.view.getViewID());
        out.writeCDOLockType(this.lockType);
        out.writeCDOID(this.object.cdoID());
        out.writeBoolean(this.byOthers);
    }

    @Override
    protected Boolean confirming(CDODataInput in) throws IOException {
        return in.readBoolean();
    }
}

