/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockStateRequest
extends CDOClientRequest<CDOLockState[]> {
    private int viewID;
    private Collection<CDOID> ids;

    public LockStateRequest(CDOClientProtocol protocol, int viewID, Collection<CDOID> ids) {
        super(protocol, (short)52);
        this.viewID = viewID;
        this.ids = ids;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        out.writeInt(this.ids.size());
        for (CDOID id : this.ids) {
            out.writeCDOID(id);
        }
    }

    @Override
    protected CDOLockState[] confirming(CDODataInput in) throws IOException {
        int n = in.readInt();
        CDOLockState[] lockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            lockStates[i] = in.readCDOLockState();
            ++i;
        }
        return lockStates;
    }
}

