/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.resource.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.IParseResult;
import org.yakindu.sct.model.sgraph.Declaration;
import org.yakindu.sct.model.sgraph.Reaction;
import org.yakindu.sct.model.sgraph.ReactionProperty;
import org.yakindu.sct.model.sgraph.Scope;
import org.yakindu.sct.model.sgraph.SpecificationElement;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Transition;
import org.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import org.yakindu.sct.model.stext.stext.StateSpecification;
import org.yakindu.sct.model.stext.stext.StatechartSpecification;
import org.yakindu.sct.model.stext.stext.TransitionReaction;
import org.yakindu.sct.model.stext.stext.TransitionSpecification;

public class StextResource
extends AbstractSCTResource {
    public StextResource(URI uri) {
        super(uri);
    }

    protected void serializeStatechart(Statechart statechart) {
        StringBuilder builder = new StringBuilder();
        for (Scope scope : statechart.getScopes()) {
            builder.append(this.serialize((EObject)scope));
            builder.append("\n");
        }
        statechart.setSpecification(builder.toString());
    }

    protected void serializeState(State state) {
        if (state.getScopes().size() != 1) {
            return;
        }
        Scope scope = (Scope)state.getScopes().get(0);
        EList declarations = scope.getDeclarations();
        StringBuilder builder = new StringBuilder();
        for (Declaration declaration : declarations) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(this.serializeReaction((Reaction)declaration));
        }
        state.setSpecification(builder.toString());
    }

    private String serializeReaction(Reaction reaction) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.serialize((EObject)reaction.getTrigger()));
        if (reaction.getEffect() != null) {
            builder.append(" / ");
            builder.append(this.serialize((EObject)reaction.getEffect()));
        }
        if (reaction.getProperties().size() > 0) {
            builder.append(" # ");
            for (ReactionProperty property : reaction.getProperties()) {
                builder.append(this.serialize((EObject)property));
            }
        }
        return builder.toString();
    }

    protected void serializeTransition(Transition transition) {
        transition.setSpecification(this.serializeReaction((Reaction)transition));
    }

    protected void parseStatechart(Statechart statechart) {
        IParseResult parseResult = this.parse((SpecificationElement)statechart, StatechartSpecification.class.getSimpleName());
        StatechartSpecification rootASTElement = (StatechartSpecification)parseResult.getRootASTElement();
        EList definitionScopes = rootASTElement.getScopes();
        statechart.getScopes().clear();
        statechart.setNamespace(rootASTElement.getNamespace());
        if (definitionScopes != null) {
            statechart.getScopes().addAll((Collection)definitionScopes);
        }
    }

    protected void parseState(State state) {
        IParseResult parseResult = this.parse((SpecificationElement)state, StateSpecification.class.getSimpleName());
        StateSpecification rootASTElement = (StateSpecification)parseResult.getRootASTElement();
        state.getScopes().clear();
        if (rootASTElement.getScope() != null) {
            state.getScopes().add((Object)rootASTElement.getScope());
        }
    }

    protected void parseTransition(Transition transition) {
        IParseResult parseResult = this.parse((SpecificationElement)transition, TransitionSpecification.class.getSimpleName());
        TransitionSpecification rootASTElement = (TransitionSpecification)parseResult.getRootASTElement();
        if (rootASTElement.getReaction() != null) {
            TransitionReaction reaction = rootASTElement.getReaction();
            transition.setEffect(reaction.getEffect());
            transition.setTrigger(reaction.getTrigger());
            transition.getProperties().addAll((Collection)reaction.getProperties());
        }
    }
}

