/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.runtime.ant.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.TransformationUtil;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtoAntTransformationTask
extends Task {
    public static final String QVTO_ANTTASK_NAME = "qvto:transformation";
    private String myModuleUri;
    private Trace myTrace;
    private final List<ModelParameter> myModelParameters = new ArrayList<ModelParameter>(3);
    private final Map<String, Object> myConfigProperties = new LinkedHashMap<String, Object>(3);
    private static final String MSDOS_FS = "\\";
    private static final String UNIX_FS = "/";

    public void setUri(String moduleUri) {
        this.myModuleUri = moduleUri;
    }

    public void addConfiguredIn(In parameter) {
        this.myModelParameters.add(parameter);
    }

    public void addConfiguredInout(Inout parameter) {
        this.myModelParameters.add(parameter);
    }

    public void addConfiguredOut(Out parameter) {
        this.myModelParameters.add(parameter);
    }

    public void addConfiguredTrace(Trace trace) {
        this.myTrace = trace;
    }

    public void addConfiguredConfigProperty(ConfigProperty configProperty) {
        this.myConfigProperties.put(configProperty.getName(), configProperty.getValue());
    }

    public void execute() throws BuildException {
        final QvtTransformation transformation = this.getTransformationObject();
        try {
            BaseProcess.IRunnable r = new BaseProcess.IRunnable(){

                public void run() throws Exception {
                    ArrayList inObjects = new ArrayList();
                    ArrayList targetData = new ArrayList();
                    QvtoAntTransformationTask.this.loadTransformationParams(transformation, inObjects, targetData);
                    String traceUri = QvtoAntTransformationTask.this.getTraceUri((ProjectComponent)QvtoAntTransformationTask.this);
                    IStatus status = QvtValidator.validateTransformation((QvtTransformation)transformation, inObjects, (String)traceUri);
                    if (status.getSeverity() > 2) {
                        throw new MdaException(status);
                    }
                    Context createContext = QvtLaunchUtil.createContext((Map)QvtoAntTransformationTask.this.getConfiguration());
                    createContext.setLog(QvtoAntTransformationTask.this.createQVTLog());
                    QvtLaunchConfigurationDelegateBase.doLaunch((QvtTransformation)transformation, inObjects, targetData, (String)traceUri, (IContext)createContext);
                    transformation.cleanup();
                }
            };
            r = QvtLaunchConfigurationDelegateBase.getSafeRunnable((QvtTransformation)transformation, (BaseProcess.IRunnable)r);
            r.run();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !(e instanceof QvtRuntimeException)) {
                e.printStackTrace();
            }
            throw new BuildException(StatusUtil.getExceptionMessages((Throwable)e), (Throwable)e);
        }
        this.log(NLS.bind((String)Messages.TransformationExecuted, (Object)this.getModuleURI((ProjectComponent)this)));
    }

    private Log createQVTLog() {
        return new Log(){

            public void log(int level, String message, Object param) {
                this.log(message, param);
            }

            public void log(int level, String message) {
                this.log(message);
            }

            public void log(String message, Object param) {
                QvtoAntTransformationTask.this.log(String.valueOf(message) + " , data:" + String.valueOf(param));
            }

            public void log(String message) {
                QvtoAntTransformationTask.this.log(message);
            }
        };
    }

    private QvtTransformation getTransformationObject() {
        try {
            return new QvtInterpretedTransformation(TransformationUtil.getQvtModule((URI)this.getModuleURI((ProjectComponent)this)));
        }
        catch (Exception e) {
            throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_File_not_found, (Object)this.getModuleURI((ProjectComponent)this)), (Throwable)e);
        }
    }

    private void loadTransformationParams(QvtTransformation transformation, List<ModelContent> inObjects, List<TargetUriData> targetData) throws MdaException {
        Integer parameterIndex = 0;
        Iterator<ModelParameter> itrModelParam = this.myModelParameters.iterator();
        for (QvtTransformation.TransformationParameter transfParam : transformation.getParameters()) {
            ModelContent inModel;
            parameterIndex = parameterIndex + 1;
            if (!itrModelParam.hasNext()) {
                throw new BuildException(NLS.bind((String)Messages.AbstractApplyTransformationTask_Required_attribute_is_not_specified, (Object)transfParam.getName()));
            }
            ModelParameter modelParam = itrModelParam.next();
            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN) {
                if (!(modelParam instanceof In)) {
                    throw new BuildException(NLS.bind((String)Messages.ModelParameterTypeMismatch, (Object[])new Object[]{parameterIndex, transfParam.getName(), QvtTransformation.TransformationParameter.DirectionKind.IN.name().toLowerCase()}));
                }
                In inParam = (In)modelParam;
                inModel = transformation.loadInput(inParam.getURI((ProjectComponent)this));
                inObjects.add(inModel);
            }
            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                if (!(modelParam instanceof Inout)) {
                    throw new BuildException(NLS.bind((String)Messages.ModelParameterTypeMismatch, (Object[])new Object[]{parameterIndex, transfParam.getName(), QvtTransformation.TransformationParameter.DirectionKind.INOUT.name().toLowerCase()}));
                }
                Inout inoutParam = (Inout)modelParam;
                inModel = transformation.loadInput(inoutParam.getURI((ProjectComponent)this));
                inObjects.add(inModel);
                targetData.add(inoutParam.getTargetUriData((ProjectComponent)this));
            }
            if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT) continue;
            if (!(modelParam instanceof Out)) {
                throw new BuildException(NLS.bind((String)Messages.ModelParameterTypeMismatch, (Object[])new Object[]{parameterIndex, transfParam.getName(), QvtTransformation.TransformationParameter.DirectionKind.OUT.name().toLowerCase()}));
            }
            Out outParam = (Out)modelParam;
            targetData.add(outParam.getTargetUriData((ProjectComponent)this));
        }
        ArrayList<ModelParameter> extraParameters = new ArrayList<ModelParameter>(2);
        while (itrModelParam.hasNext()) {
            ModelParameter modelParam = itrModelParam.next();
            extraParameters.add(modelParam);
        }
        if (!extraParameters.isEmpty()) {
            throw new BuildException(NLS.bind((String)Messages.ExtraModelParameter, extraParameters));
        }
    }

    private URI getModuleURI(ProjectComponent project) {
        return QvtoAntTransformationTask.toUri(this.myModuleUri, project);
    }

    private String getTraceUri(ProjectComponent project) {
        if (this.myTrace == null) {
            return null;
        }
        return this.myTrace.getURI(project).toString();
    }

    private Map<String, Object> getConfiguration() {
        return this.myConfigProperties;
    }

    private static URI toUri(String uriString, ProjectComponent project) throws BuildException {
        try {
            URI uri = URI.createURI((String)uriString);
            if (uri == null) {
                throw new BuildException(NLS.bind((String)Messages.InvalidUriSpecified, (Object)uriString));
            }
            if (uri.isRelative() && !uriString.trim().startsWith(MSDOS_FS) && !uriString.trim().startsWith(UNIX_FS)) {
                URI baseUri = URI.createFileURI((String)project.getProject().getBaseDir().getAbsolutePath());
                uri = baseUri.appendSegments(uri.segments());
                IFile wsfile = WorkspaceUtils.getIFile((String)uri.toFileString());
                uri = URI.createURI((String)wsfile.getFullPath().toPortableString());
            }
            return uri;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static class ConfigProperty {
        private String myName;
        private String myValue;

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getValue() {
            return this.myValue;
        }

        public void setValue(String value) {
            this.myValue = value;
        }
    }

    public static class Feature {
        private String myName;
        private String myClearcontents;

        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public String getClearContents() {
            return this.myClearcontents;
        }

        public void setClearcontents(String clearcontents) {
            this.myClearcontents = clearcontents;
        }
    }

    public static class In
    implements ModelParameter {
        private String myUri;

        URI getURI(ProjectComponent project) {
            return QvtoAntTransformationTask.toUri(this.myUri, project);
        }

        public void setUri(String uri) {
            this.myUri = uri;
        }

        public String toString() {
            return "IN uri=" + this.myUri;
        }
    }

    public static class Inout
    implements ModelParameter {
        private String myUri;
        private String myOutUri;

        URI getURI(ProjectComponent project) {
            return QvtoAntTransformationTask.toUri(this.myUri, project);
        }

        public void setUri(String uri) {
            this.myUri = uri;
        }

        URI getOutURI(ProjectComponent project) {
            String outUriString = this.myOutUri != null && this.myOutUri.trim().length() > 0 ? this.myOutUri : this.myUri;
            return QvtoAntTransformationTask.toUri(outUriString, project);
        }

        public void setOuturi(String uri) {
            this.myOutUri = uri;
        }

        TargetUriData getTargetUriData(ProjectComponent project) {
            return new TargetUriData(this.getOutURI(project).toString());
        }

        public String toString() {
            return "INOUT uri=" + this.myUri;
        }
    }

    public static interface ModelParameter {
    }

    public static class Out
    implements ModelParameter {
        private String myUri;
        private Feature myFeature;

        URI getURI(ProjectComponent project) {
            return QvtoAntTransformationTask.toUri(this.myUri, project);
        }

        public void setUri(String uri) {
            this.myUri = uri;
        }

        public void addConfiguredFeature(Feature feature) {
            this.myFeature = feature;
        }

        TargetUriData getTargetUriData(ProjectComponent project) {
            String feature = this.myFeature != null ? this.myFeature.getName() : null;
            return new TargetUriData(feature != null && feature.trim().length() > 0 ? TargetUriData.TargetType.EXISTING_CONTAINER : TargetUriData.TargetType.NEW_MODEL, this.getURI(project).toString(), feature, this.myFeature != null ? Boolean.valueOf(this.myFeature.getClearContents()) : false);
        }

        public String toString() {
            return "OUT uri=" + this.myUri;
        }
    }

    public static class Trace {
        private String myUri;

        public URI getURI(ProjectComponent project) {
            return QvtoAntTransformationTask.toUri(this.myUri, project);
        }

        public void setUri(String uri) {
            this.myUri = uri;
        }
    }
}

