/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.GEFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.requests.ShowHideRelatedLinkRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.eclipse.papyrus.infra.tools.util.EditorHelper;
import org.eclipse.papyrus.uml.diagram.menu.Activator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowHideRelatedLinkHandler
extends AbstractHandler
implements IExecutableExtension {
    protected final List<EditPart> selection = new ArrayList<EditPart>();
    private final String parameterID = "showHideRelatedLinkParameter";
    private ShowHideRelatedLinkRequest.ShowHideKind kind;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable && "showHideRelatedLinkParameter" != null) {
            this.kind = ShowHideRelatedLinkRequest.ShowHideKind.valueOf((String)((String)((Hashtable)data).get("showHideRelatedLinkParameter")));
        }
    }

    protected boolean hasRequiredEditPolicy(EditPart ep, String editPolicyRole) {
        return ep.getEditPolicy((Object)editPolicyRole) != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Request request = this.buildRequest();
        DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.selection.get(0));
        TransactionalEditingDomain domain = this.getEditingDomain();
        if (diagramEP != null && domain != null) {
            org.eclipse.gef.commands.Command cmd = diagramEP.getCommand(request);
            domain.getCommandStack().execute((Command)new GEFtoEMFCommandWrapper(cmd));
        }
        return null;
    }

    protected Request buildRequest() {
        switch (this.kind) {
            case SHOW_ALL_LINK_IN_DIAGRAM: {
                return new ShowHideRelatedLinkRequest(this.getAllTopSemanticEditParts(), this.kind);
            }
        }
        return new ShowHideRelatedLinkRequest(this.selection, this.kind);
    }

    protected Collection<EditPart> getAllTopSemanticEditParts() {
        DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.selection.get(0));
        return DiagramEditPartsUtil.getAllTopSemanticEditPart((EditPart)diagramEP);
    }

    public void setEnabled(Object evaluationContext) {
        this.buildSelection();
        DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.selection.get(0));
        if (this.kind.equals((Object)ShowHideRelatedLinkRequest.ShowHideKind.SHOW_ALL_LINK_IN_DIAGRAM)) {
            this.setBaseEnabled(!this.getAllTopSemanticEditParts().isEmpty() && this.hasRequiredEditPolicy((EditPart)diagramEP, "ShowHideRelatedLinkEditPolicy"));
        } else {
            this.setBaseEnabled(!this.selection.isEmpty() && this.hasRequiredEditPolicy((EditPart)diagramEP, "ShowHideRelatedLinkEditPolicy"));
        }
    }

    protected void buildSelection() {
        this.selection.clear();
        ISelection selection = ShowHideRelatedLinkHandler.getSelectionInCurrentEditor();
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> eobjectsAlreadyManaged = new ArrayList<EObject>();
            for (Object current : (IStructuredSelection)selection) {
                EObject currentEObject;
                EditPart top;
                if (!(current instanceof EditPart) || !((top = DiagramEditPartsUtil.getTopSemanticEditPart((EditPart)((EditPart)current))) instanceof IGraphicalEditPart) || eobjectsAlreadyManaged.contains(currentEObject = EMFHelper.getEObject((Object)top))) continue;
                this.selection.add((EditPart)((IGraphicalEditPart)top));
                eobjectsAlreadyManaged.add(currentEObject);
            }
        }
    }

    public static final ISelection getSelectionInCurrentEditor() {
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite site;
        IEditorPart editorPart = EditorHelper.getCurrentEditor();
        if (editorPart != null && (site = editorPart.getSite()) != null && (selectionProvider = site.getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        if (!this.selection.isEmpty()) {
            try {
                return ServiceUtilsForEditPart.getInstance().getTransactionalEditingDomain((Object)this.selection.get(0));
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }
}

