/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.composites;

import java.util.List;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.model.ProvidersLabelProvider;
import org.eclipse.emf.ecp.spi.ui.CompositeStateObserver;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.emf.ecp.ui.common.CreateProjectComposite;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateProjectCompositeImpl
implements CreateProjectComposite {
    private CreateProjectComposite.CreateProjectChangeListener listener;
    private final List<ECPProvider> providers;
    private ECPProvider provider;
    private String projectName;
    private StackLayout providerStackLayout;
    private Composite providerStack;
    private boolean status;
    private boolean topStatus;
    private boolean compositeStatus;
    private ECPProperties properties;

    public CreateProjectCompositeImpl(List<ECPProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Composite createUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        ComboViewer providersViewer = null;
        if (this.providers.size() > 1) {
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            label.setText(String.valueOf(Messages.UICreateProject_ProjectProvider) + ":");
            providersViewer = new ComboViewer(composite, 8);
            Combo combo = providersViewer.getCombo();
            GridData gdCombo = new GridData(4, 1, true, false, 1, 1);
            gdCombo.minimumWidth = 150;
            combo.setLayoutData((Object)gdCombo);
            providersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            providersViewer.setLabelProvider((IBaseLabelProvider)new ProvidersLabelProvider());
            providersViewer.setSorter(new ViewerSorter());
            providersViewer.setInput(this.providers);
            providersViewer.setSelection((ISelection)new StructuredSelection((Object)this.providers.get(0)));
            providersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    CreateProjectCompositeImpl.this.provider = (ECPProvider)selection.getFirstElement();
                    CreateProjectCompositeImpl.this.updateUI();
                    if (CreateProjectCompositeImpl.this.listener != null) {
                        CreateProjectCompositeImpl.this.listener.providerChanged(CreateProjectCompositeImpl.this.provider);
                    }
                }
            });
        }
        this.provider = this.providers.get(0);
        Label labelName = new Label(composite, 0);
        labelName.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        labelName.setText(String.valueOf(Messages.UICreateProject_ProjectName) + ":");
        final Text textProjectName = new Text(composite, 2052);
        textProjectName.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        textProjectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateProjectCompositeImpl.this.projectName = textProjectName.getText();
                if (CreateProjectCompositeImpl.this.projectName.equals("")) {
                    CreateProjectCompositeImpl.this.projectName = null;
                }
                if (CreateProjectCompositeImpl.this.projectName == null) {
                    CreateProjectCompositeImpl.this.topStatus = false;
                } else if (ECPUtil.getECPProjectManager().getProject(CreateProjectCompositeImpl.this.projectName) != null) {
                    CreateProjectCompositeImpl.this.topStatus = false;
                } else {
                    CreateProjectCompositeImpl.this.topStatus = true;
                }
                if (CreateProjectCompositeImpl.this.listener != null) {
                    CreateProjectCompositeImpl.this.listener.projectNameChanged(CreateProjectCompositeImpl.this.projectName);
                }
                CreateProjectCompositeImpl.this.checkComplete();
            }
        });
        Label seperator = new Label(composite, 258);
        seperator.setLayoutData((Object)new GridData(4, 1024, false, false, 2, 2));
        this.providerStackLayout = new StackLayout();
        this.providerStack = new Composite(composite, 0);
        this.providerStack.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.providerStack.setLayout((Layout)this.providerStackLayout);
        this.updateUI();
        return composite;
    }

    private void updateUI() {
        UIProvider uiProvider = UIProviderRegistry.INSTANCE.getUIProvider(this.provider);
        Control newProjectUI = uiProvider.createNewProjectUI(this.providerStack, new CompositeStateObserver(){

            @Override
            public void compositeChangedState(Composite caller, boolean complete, ECPProperties projectProperties) {
                CreateProjectCompositeImpl.this.compositeStatus = complete;
                CreateProjectCompositeImpl.this.properties = projectProperties;
                CreateProjectCompositeImpl.this.checkComplete();
            }
        }, ECPUtil.createProperties());
        if (newProjectUI != null) {
            this.providerStackLayout.topControl = newProjectUI;
        } else {
            this.providerStackLayout.topControl = null;
            this.compositeStatus = true;
            this.properties = null;
            this.checkComplete();
        }
        this.providerStack.layout();
    }

    private void checkComplete() {
        if (this.status != (this.topStatus && this.compositeStatus)) {
            boolean bl = this.status = !this.status;
            if (this.listener != null) {
                this.listener.completeStatusChanged(this.status);
            }
        }
    }

    @Override
    public ECPProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public void setListener(CreateProjectComposite.CreateProjectChangeListener listener) {
        this.listener = listener;
        if (listener != null) {
            listener.completeStatusChanged(this.status);
            listener.projectNameChanged(this.projectName);
            listener.providerChanged(this.provider);
        }
    }

    @Override
    public ECPProperties getProperties() {
        return this.properties == null ? ECPUtil.createProperties() : this.properties;
    }

    @Override
    public void dispose() {
    }
}

