/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.controlmode;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDiagramsCommand
extends AbstractControlCommand {
    public ControlDiagramsCommand(ControlModeRequest request) {
        super("Move diagram to new resource", null, request);
        try {
            this.getAffectedFiles().addAll(ControlDiagramsCommand.getWorkspaceFiles(this.getDiagrams()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void addMovedDiagramToRequest(List<Diagram> diags) {
        ArrayList<Diagram> openables = (ArrayList<Diagram>)this.getRequest().getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables");
        if (openables == null) {
            openables = new ArrayList<Diagram>();
        }
        openables.addAll(diags);
        this.getRequest().addParameters(Collections.singletonMap("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.MovedOpenables", openables));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        EObject objectTOControl = this.getRequest().getTargetObject();
        EMFHelper.getUsages((EObject)objectTOControl);
        Resource newNotationResource = this.getRequest().getTargetResource("notation");
        if (newNotationResource == null) {
            return CommandResult.newErrorCommandResult((String)"The notation model has not been created");
        }
        List<Diagram> diagrams = this.getDiagrams();
        if (!diagrams.isEmpty()) {
            newNotationResource.getContents().addAll(diagrams);
            this.addMovedDiagramToRequest(diagrams);
        }
        return CommandResult.newOKCommandResult((Object)newNotationResource);
    }

    protected List<Diagram> getDiagrams() throws ExecutionException {
        Resource notationResource = null;
        try {
            notationResource = this.getRequest().getModelSet().getResource(this.getOldNotationURI(), true);
        }
        catch (Exception e) {
            notationResource = null;
        }
        if (notationResource == null) {
            throw new ExecutionException("unable to retrieve old notation resource");
        }
        return NotationUtils.getDiagrams((Resource)notationResource, (EObject)this.getRequest().getTargetObject());
    }

    protected URI getOldNotationURI() throws ExecutionException {
        URI uri = this.getRequest().getSourceURI();
        if (uri != null) {
            return uri.trimFileExtension().appendFileExtension("notation");
        }
        throw new ExecutionException("Unable to retreive URI of the old notation model");
    }
}

