/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.validation;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import org.yakindu.sct.ui.editor.validation.IMarkerType;

public class SCTValidationJob
extends Job
implements IMarkerType {
    @Inject
    private IResourceValidator validator;
    @Inject
    private MarkerCreator creator;
    private Resource resource;

    public SCTValidationJob() {
        super("validation");
    }

    public IStatus run(final IProgressMonitor monitor) {
        try {
            if (!this.resource.isLoaded()) {
                return Status.CANCEL_STATUS;
            }
            if (this.resource instanceof AbstractSCTResource) {
                this.relinkModel(monitor, (AbstractSCTResource)this.resource);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            TransactionalValidationRunner runner = new TransactionalValidationRunner(this.validator, this.resource, CheckMode.ALL, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.resource);
            if (editingDomain == null) {
                return Status.CANCEL_STATUS;
            }
            editingDomain.runExclusive((Runnable)((Object)runner));
            List issues = (List)runner.getResult();
            if (issues == null) {
                return Status.CANCEL_STATUS;
            }
            IFile target = WorkspaceSynchronizer.getFile((Resource)this.resource);
            this.refreshMarkers(target, issues, monitor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Status(4, "org.yakindu.sct.ui.editor", ex.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void refreshMarkers(final IFile target, final List<Issue> issues, final IProgressMonitor monitor) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    target.deleteMarkers("org.yakindu.sct.ui.editor.diagnostic", true, 0);
                    for (Issue issue : issues) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        SCTValidationJob.this.creator.createMarker(issue, (IResource)target, "org.yakindu.sct.ui.editor.diagnostic");
                    }
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
        });
    }

    protected void relinkModel(IProgressMonitor monitor, final AbstractSCTResource eResource) throws ExecutionException {
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((Resource)eResource), "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                eResource.linkSpecificationElements();
                return CommandResult.newOKCommandResult();
            }
        };
        cmd.execute(monitor, null);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public static class TransactionalValidationRunner
    extends RunnableWithResult.Impl<List<Issue>> {
        private IResourceValidator validator;
        private Resource resource;
        private CheckMode checkMode;
        private CancelIndicator indicator;

        public TransactionalValidationRunner(IResourceValidator validator, Resource resource, CheckMode checkMode, CancelIndicator indicator) {
            this.validator = validator;
            this.resource = resource;
            this.checkMode = checkMode;
            this.indicator = indicator;
        }

        public void run() {
            List result = this.validator.validate(this.resource, this.checkMode, this.indicator);
            this.setResult(result);
            this.setStatus(Status.OK_STATUS);
        }
    }
}

