/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.policies;

import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ContextSensitiveHelpPolicy
extends SelectionEditPolicy {
    private static final String HELP_VIEW_ID = "org.eclipse.help.ui.HelpView";
    private String helpContextId;

    public ContextSensitiveHelpPolicy(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    protected void showSelection() {
        if (ContextSensitiveHelpPolicy.isDynamicHelpViewShowing()) {
            this.displayViewerHelpContext(this.helpContextId);
        }
    }

    protected void hideSelection() {
        if (ContextSensitiveHelpPolicy.isDynamicHelpViewShowing()) {
            this.displayViewerHelpContext("org.yakindu.sct.ui.editor.sc_editor_graphical_viewer");
        }
    }

    private void displayViewerHelpContext(String helpContextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getHost().getViewer().getControl(), helpContextId);
        PlatformUI.getWorkbench().getHelpSystem().displayDynamicHelp();
    }

    public static boolean isDynamicHelpViewShowing() {
        IViewPart view;
        IWorkbenchPage activePage;
        boolean open = false;
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && (view = activePage.findView(HELP_VIEW_ID)) != null) {
            open = true;
        }
        return open;
    }
}

