/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.partitioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.BreadcrumbViewer;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.IBreadcrumbDropDownSite;
import org.eclipse.debug.internal.ui.viewers.breadcrumb.TreeViewerDropDown;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.yakindu.sct.model.sgraph.CompositeElement;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Vertex;
import org.yakindu.sct.model.sgraph.provider.SGraphItemProviderAdapterFactory;
import org.yakindu.sct.model.sgraph.provider.StateItemProvider;
import org.yakindu.sct.model.sgraph.provider.StatechartItemProvider;
import org.yakindu.sct.ui.editor.StatechartImages;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;

public class DiagramPartitioningBreadcrumbViewer
extends BreadcrumbViewer
implements ISelectionChangedListener {
    public DiagramPartitioningBreadcrumbViewer(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createDropDown(Composite parent, IBreadcrumbDropDownSite site, TreePath path) {
        Control result = this.createDropDownControl(parent, site, path);
        return result;
    }

    public Control createDropDownControl(Composite parent, final IBreadcrumbDropDownSite site, final TreePath paramPath) {
        TreeViewerDropDown dropDownTreeViewer = new TreeViewerDropDown(){

            protected TreeViewer createTreeViewer(Composite composite, int style, TreePath path) {
                return DiagramPartitioningBreadcrumbViewer.this.createDropDownTreeViewer(composite, paramPath, site);
            }
        };
        return dropDownTreeViewer.createDropDown(parent, site, paramPath);
    }

    protected TreeViewer createDropDownTreeViewer(Composite composite, TreePath paramPath, IBreadcrumbDropDownSite site) {
        Diagram diagram = (Diagram)paramPath.getParentPath().getLastSegment();
        TreeViewer viewer = null;
        viewer = diagram != null ? this.createDiagramViewer(composite, diagram) : this.createProjectStatechartViewer(composite, (Diagram)paramPath.getLastSegment());
        viewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DiagramPartitioningBreadcrumbViewer.this.getDropDownShell().pack(true);
            }
        });
        return viewer;
    }

    protected TreeViewer createProjectStatechartViewer(Composite composite, Diagram diagram) {
        TreeViewer viewer = new TreeViewer(composite);
        viewer.setLabelProvider((IBaseLabelProvider)new StatechartLabelProvider());
        viewer.setContentProvider((IContentProvider)new StatechartContentProvider());
        viewer.setInput(this.getProjectStatechartInput(diagram));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return viewer;
    }

    protected Set<IFile> getProjectStatechartInput(Diagram diagram) {
        final IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        IProject project = file.getProject();
        final HashSet<IFile> result = new HashSet<IFile>();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.isHidden()) {
                        return false;
                    }
                    if (resource instanceof IFile && file.getFileExtension().equals(resource.getFileExtension())) {
                        result.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected TreeViewer createDiagramViewer(Composite composite, Diagram diagram) {
        TreeViewer viewer = new TreeViewer(composite);
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new SGraphItemProviderAdapterFactory()));
        viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new BreadcrumbItemProviderAdapterFactory()));
        EObject element = diagram.getElement();
        viewer.setInput((Object)element);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return viewer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selection instanceof State || selection instanceof Statechart) {
            Diagram diagram = DiagramPartitioningUtil.getSubDiagram((CompositeElement)selection);
            DiagramPartitioningUtil.openEditor(diagram);
        } else if (selection instanceof IFile) {
            DiagramPartitioningUtil.openEditor((IFile)selection);
        }
    }

    public static final class BreadcrumbItemProviderAdapterFactory
    extends SGraphItemProviderAdapterFactory {
        public Adapter createStatechartAdapter() {
            if (this.statechartItemProvider == null) {
                this.statechartItemProvider = new StatechartItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        return BreadcrumbItemProviderAdapterFactory.this.collectSubdiagrams((CompositeElement)object);
                    }
                };
            }
            return this.statechartItemProvider;
        }

        public Adapter createStateAdapter() {
            if (this.stateItemProvider == null) {
                this.stateItemProvider = new StateItemProvider((AdapterFactory)this){

                    public Collection<?> getChildren(Object object) {
                        return BreadcrumbItemProviderAdapterFactory.this.collectSubdiagrams((CompositeElement)object);
                    }
                };
            }
            return this.stateItemProvider;
        }

        private Collection<?> collectSubdiagrams(CompositeElement state) {
            ArrayList<Vertex> result = new ArrayList<Vertex>();
            EList regions = state.getRegions();
            for (Region region : regions) {
                EList vertices = region.getVertices();
                for (Vertex vertex : vertices) {
                    if (!(vertex instanceof State) || DiagramPartitioningUtil.getSubDiagram((CompositeElement)vertex) == null) continue;
                    result.add(vertex);
                }
            }
            return result;
        }
    }

    public static final class StatechartContentProvider
    implements ITreeContentProvider {
        private Set<IFile> newInput;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.newInput = (Set)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.newInput.toArray(new Object[0]);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    public static final class StatechartLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return StatechartImages.LOGO.image();
        }

        public String getText(Object element) {
            return ((IFile)element).getFullPath().toString();
        }
    }
}

