/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.editparts;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.Compartment;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.RGB;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.ui.editor.editor.figures.StateFigure;
import org.yakindu.sct.ui.editor.editor.figures.utils.GridDataFactory;
import org.yakindu.sct.ui.editor.editor.figures.utils.MapModeUtils;
import org.yakindu.sct.ui.editor.editparts.RegionEditPart;
import org.yakindu.sct.ui.editor.editparts.StateFigureCompartmentEditPart;
import org.yakindu.sct.ui.editor.editparts.StateNameEditPart;
import org.yakindu.sct.ui.editor.editparts.StateTextCompartmentEditPart;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import org.yakindu.sct.ui.editor.policies.EnlargeContainerEditPolicy;
import org.yakindu.sct.ui.editor.policies.PreferredSizeHandlerEditPolicy;
import org.yakindu.sct.ui.editor.preferences.StatechartColorConstants;

public class StateEditPart
extends ShapeNodeEditPart
implements IPrimaryEditPart {
    private EditPart figureCompartmentEditPart;

    public StateEditPart(View view) {
        super(view);
    }

    public EditPart getTargetEditPart(Request request) {
        GroupRequest req;
        if (request instanceof CreateViewAndElementRequest) {
            return this.figureCompartmentEditPart;
        }
        if (request instanceof GroupRequest && request.getType() == "drop" && this.areInsertableChildren((req = (GroupRequest)request).getEditParts())) {
            return this.figureCompartmentEditPart;
        }
        return super.getTargetEditPart(request);
    }

    private boolean areInsertableChildren(List<?> editParts) {
        for (Object object : editParts) {
            if (object instanceof RegionEditPart) continue;
            return false;
        }
        return true;
    }

    protected NodeFigure createNodeFigure() {
        DefaultSizeNodeFigure figure = new DefaultSizeNodeFigure(this.getDefaultSize()){

            public Rectangle getHandleBounds() {
                Insets insets = new Insets(0, 0, 5, 5);
                return new Rectangle(this.getBounds().x + insets.left, this.getBounds().y + insets.top, this.getBounds().width - (insets.right + insets.left), this.getBounds().height - (insets.bottom + insets.top));
            }
        };
        figure.setLayoutManager((LayoutManager)new StackLayout());
        figure.setMinimumSize(this.getDefaultSize());
        figure.add((IFigure)this.createPrimaryShape());
        return figure;
    }

    protected Dimension getDefaultSize() {
        return MapModeUtils.getDefaultSizeDimension(this.getMapMode());
    }

    public StateFigure createPrimaryShape() {
        return new StateFigure(this.getMapMode());
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("CreationPolicy");
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new PreferredSizeHandlerEditPolicy());
        this.installEditPolicy(EnlargeContainerEditPolicy.ROLE, (EditPolicy)new EnlargeContainerEditPolicy());
    }

    protected void refreshVisuals() {
        this.refreshCompartmentLayout();
        super.refreshVisuals();
    }

    private void refreshCompartmentLayout() {
        if (this.getTextCompartment().isCollapsed()) {
            this.getPrimaryShape().setConstraint((IFigure)this.getPrimaryShape().getTextCompartmentPane(), this.getCollapsedData());
        } else {
            GridData expandedData = this.getExpandedData();
            if (this.figureCompartmentVisible()) {
                expandedData.grabExcessVerticalSpace = false;
            }
            this.getPrimaryShape().setConstraint((IFigure)this.getPrimaryShape().getTextCompartmentPane(), expandedData);
        }
        if (!this.figureCompartmentVisible()) {
            this.getPrimaryShape().setConstraint((IFigure)this.getPrimaryShape().getFigureCompartmentPane(), this.getCollapsedData());
        } else {
            this.getPrimaryShape().setConstraint((IFigure)this.getPrimaryShape().getFigureCompartmentPane(), this.getExpandedData());
        }
    }

    private boolean figureCompartmentVisible() {
        BooleanValueStyle inlineStyle = DiagramPartitioningUtil.getInlineStyle(this.getNotationView());
        return this.resolveSemanticElement().getRegions().size() > 0 && (inlineStyle == null || inlineStyle.isBooleanValue());
    }

    private GridData getExpandedData() {
        return GridDataFactory.fillDefaults().grab(true, true).getData();
    }

    private GridData getCollapsedData() {
        return GridDataFactory.fillDefaults().grab(false, false).getData();
    }

    private Compartment getTextCompartment() {
        return (Compartment)ViewUtil.getChildBySemanticHint((View)this.getNotationView(), (String)"StateTextCompartment");
    }

    public IFigure getContentPane() {
        return this.getPrimaryShape().getFigureCompartmentPane();
    }

    public StateFigure getPrimaryShape() {
        return (StateFigure)((Object)this.getFigure().getChildren().get(0));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof StateFigureCompartmentEditPart) {
            this.figureCompartmentEditPart = childEditPart;
            Figure pane = this.getPrimaryShape().getFigureCompartmentPane();
            IFigure compartmentFigure = ((StateFigureCompartmentEditPart)childEditPart).getFigure();
            pane.add(compartmentFigure);
        } else if (childEditPart instanceof StateNameEditPart) {
            ((StateNameEditPart)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameFigure());
        } else if (childEditPart instanceof StateTextCompartmentEditPart) {
            Figure pane = this.getPrimaryShape().getTextCompartmentPane();
            IFigure compartmentFigure = ((StateTextCompartmentEditPart)childEditPart).getFigure();
            pane.add(compartmentFigure);
        } else {
            super.addChildVisual(childEditPart, index);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (childEditPart instanceof StateFigureCompartmentEditPart) {
            Figure pane = this.getPrimaryShape().getFigureCompartmentPane();
            IFigure compartmentFigure = ((StateFigureCompartmentEditPart)childEditPart).getFigure();
            pane.remove(compartmentFigure);
        } else if (childEditPart instanceof StateTextCompartmentEditPart) {
            Figure pane = this.getPrimaryShape().getTextCompartmentPane();
            IFigure compartmentFigure = ((StateTextCompartmentEditPart)childEditPart).getFigure();
            pane.remove(compartmentFigure);
        } else {
            super.removeChildVisual(childEditPart);
        }
    }

    protected void addNotationalListeners() {
        super.addNotationalListeners();
        this.addListenerFilter("TextCompartmentView", (NotificationListener)this, (EObject)ViewUtil.getChildBySemanticHint((View)this.getNotationView(), (String)"StateTextCompartment"));
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("TextCompartmentView");
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
            return FigureUtilities.RGBToInteger((RGB)StatechartColorConstants.STATE_LINE_COLOR.getRGB());
        }
        if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            return FigureUtilities.RGBToInteger((RGB)StatechartColorConstants.STATE_BG_COLOR.getRGB());
        }
        return super.getPreferredValue(feature);
    }

    public State resolveSemanticElement() {
        return (State)super.resolveSemanticElement();
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getFeature() == NotationPackage.Literals.BOOLEAN_VALUE_STYLE__BOOLEAN_VALUE) {
            this.refresh();
        }
        if (notification.getFeature() == NotationPackage.Literals.DRAWER_STYLE__COLLAPSED) {
            this.refreshVisuals();
        }
        if (notification.getFeature() == SGraphPackage.Literals.COMPOSITE_ELEMENT__REGIONS) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(notification);
    }
}

