/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.editor.figures.utils;

import java.util.Arrays;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class ImageRenderer {
    public ImageData calculateVerticalAlphaGradient(Rectangle bounds, RGB color, int alphaMax) {
        RGB[] colors = new RGB[]{new RGB(0, 0, 0), color != null ? color : new RGB(255, 255, 255)};
        PaletteData pd = new PaletteData(colors);
        int bytesPerRow = bounds.width / 8 + (bounds.width % 8 != 0 ? 1 : 0);
        byte[] data = new byte[bytesPerRow * bounds.height];
        Arrays.fill(data, (byte)-1);
        ImageData id = new ImageData(bounds.width, bounds.height, 1, pd, 1, data);
        id.alphaData = new byte[bounds.width * bounds.height];
        byte[] alphaData = id.alphaData;
        double alphaFactor = alphaMax;
        double height = bounds.height;
        int i = 0;
        while (i < bounds.height) {
            double ratio = 1.0 - Math.sin((double)i / height * Math.PI / 2.0);
            byte alphaValue = (byte)(ratio * alphaFactor);
            Arrays.fill(alphaData, i * bounds.width, i * bounds.width + bounds.width, alphaValue);
            ++i;
        }
        return id;
    }

    public ImageData maskAlphaAsRoundedrectangle(ImageData imageData, Dimension corner, int alphaValue) {
        byte[] alphaData = imageData.alphaData;
        int width = imageData.width;
        int height = imageData.height;
        int r = corner.width / 2;
        double r_square = r * r;
        byte[] alphaPixel = new byte[r];
        Arrays.fill(alphaPixel, (byte)alphaValue);
        r = Math.min(r, Math.min(imageData.height, imageData.width) / 2);
        int i = 0;
        while (i < r) {
            int p = r - (int)Math.sqrt(r_square - (double)(i * i));
            if (p > 0) {
                System.arraycopy(alphaPixel, 0, alphaData, (r - (i + 1)) * width, p);
                System.arraycopy(alphaPixel, 0, alphaData, (r - (i + 1)) * width + (width - p), p);
                System.arraycopy(alphaPixel, 0, alphaData, (height - (r - i)) * width, p);
                System.arraycopy(alphaPixel, 0, alphaData, (height - (r - i)) * width + (width - p), p);
            }
            ++i;
        }
        return imageData;
    }

    protected ImageData calculateVerticalRoundedRectangleLinearColorGradient(Rectangle bounds, Dimension corner, RGB c1, RGB c2) {
        PaletteData pd = new PaletteData(0xFF0000, 65280, 255);
        byte[] data = new byte[3 * bounds.width * bounds.height];
        int i = 0;
        while (i < bounds.width) {
            double ratio = (double)i / (double)bounds.width;
            int red = (int)((double)c1.red * (1.0 - ratio) + (double)c2.red * ratio);
            int green = (int)((double)c1.green * (1.0 - ratio) + (double)c2.green * ratio);
            int blue = (int)((double)c1.blue * (1.0 - ratio) + (double)c2.blue * ratio);
            data[i * 3 + 0] = (byte)red;
            data[i * 3 + 1] = (byte)green;
            data[i * 3 + 2] = (byte)blue;
            ++i;
        }
        i = 1;
        while (i < bounds.height) {
            System.arraycopy(data, 0, data, i * 3 * bounds.width, 3 * bounds.width);
            ++i;
        }
        int r = corner.width / 2;
        double r_square = r * r;
        byte[] alphaPixel = new byte[r * 3];
        Arrays.fill(alphaPixel, (byte)0);
        int i2 = 0;
        while (i2 < r) {
            int p = r - (int)Math.sqrt(r_square - (double)(i2 * i2));
            if (p > 0) {
                System.arraycopy(alphaPixel, 0, data, (r - (i2 + 1)) * 3 * bounds.width, p * 3);
                System.arraycopy(alphaPixel, 0, data, (r - (i2 + 1)) * 3 * bounds.width + (bounds.width - p) * 3, p * 3);
                System.arraycopy(alphaPixel, 0, data, (bounds.height - (r - i2)) * 3 * bounds.width, p * 3);
                System.arraycopy(alphaPixel, 0, data, (bounds.height - (r - i2)) * 3 * bounds.width + (bounds.width - p) * 3, p * 3);
            }
            ++i2;
        }
        ImageData id = new ImageData(bounds.width, bounds.height, 24, pd, 3, data);
        id.transparentPixel = 0;
        return id;
    }
}

