/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.ui.editor.editor;

import com.google.inject.Injector;
import de.itemis.xtext.utils.gmf.resource.DirtyStateListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.DiagramGraphicalViewerKeyHandler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.xtext.ui.XtextProjectHelper;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.ui.editor.DiagramActivator;
import org.yakindu.sct.ui.editor.editor.proposals.ContentProposalViewerKeyHandler;
import org.yakindu.sct.ui.editor.extensions.ExpressionLanguageProviderExtensions;
import org.yakindu.sct.ui.editor.extensions.IExpressionLanguageProvider;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningEditor;
import org.yakindu.sct.ui.editor.partitioning.DiagramPartitioningUtil;
import org.yakindu.sct.ui.editor.validation.SCTValidationJob;

public class StatechartDiagramEditor
extends DiagramPartitioningEditor
implements IGotoMarker {
    public static final String ID = "org.yakindu.sct.ui.editor.editor.StatechartDiagramEditor";
    private static final int DELAY = 200;
    private ResourceSetListener validationListener = new ResourceSetListenerImpl(){

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            for (Notification notification : event.getNotifications()) {
                if (!(notification.getNotifier() instanceof EObject) || notification.getEventType() == 8 || notification.getEventType() == 9) continue;
                EObject eObject = (EObject)notification.getNotifier();
                if (eObject.eClass().getEPackage() == SGraphPackage.eINSTANCE) {
                    StatechartDiagramEditor.this.validationJob.cancel();
                    StatechartDiagramEditor.this.validationJob.schedule(200L);
                    continue;
                }
                for (EClass eClass : eObject.eClass().getEAllSuperTypes()) {
                    if (SGraphPackage.eINSTANCE != eClass.getEPackage()) continue;
                    StatechartDiagramEditor.this.validationJob.cancel();
                    StatechartDiagramEditor.this.validationJob.schedule(200L);
                    return;
                }
            }
        }
    };
    private DirtyStateListener domainAdapter;
    private SCTValidationJob validationJob;

    public StatechartDiagramEditor() {
        super(true);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getEditingDomain().addResourceSetListener(this.validationListener);
        this.checkXtextNature();
        this.initValidationJob();
    }

    private void initValidationJob() {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        this.validationJob = new SCTValidationJob();
        this.validationJob.setResource(this.getDiagram().eResource());
        IExpressionLanguageProvider registeredProvider = ExpressionLanguageProviderExtensions.getRegisteredProvider(ExpressionLanguageProviderExtensions.SemanticTarget.StatechartSpecification, file.getFileExtension());
        Injector injector = registeredProvider.getInjector();
        injector.injectMembers((Object)this.validationJob);
        this.validationJob.setRule((ISchedulingRule)file);
    }

    private void checkXtextNature() {
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        IProject project = editorInput.getFile().getProject();
        if (project != null && !XtextProjectHelper.hasNature((IProject)project) && project.isAccessible() && !project.isHidden()) {
            this.addNature(project);
        }
    }

    public void addNature(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.xtext.ui.shared.xtextNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain domain = DiagramPartitioningUtil.getSharedDomain();
        this.domainAdapter = new DirtyStateListener();
        domain.addResourceSetListener((ResourceSetListener)this.domainAdapter);
        return domain;
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    protected PreferencesHint getPreferencesHint() {
        return DiagramActivator.DIAGRAM_PREFERENCES_HINT;
    }

    @Override
    protected void createGraphicalViewer(Composite parent) {
        super.createGraphicalViewer(parent);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp(this.getGraphicalViewer().getControl(), "org.yakindu.sct.ui.editor.sc_editor_graphical_viewer");
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.createContentProposalViewerKeyHandler();
    }

    protected void createContentProposalViewerKeyHandler() {
        ContentProposalViewerKeyHandler contentProposalHandler = new ContentProposalViewerKeyHandler(this.getGraphicalViewer());
        contentProposalHandler.setParent((KeyHandler)new DiagramGraphicalViewerKeyHandler(this.getGraphicalViewer()));
        this.getGraphicalViewer().setKeyHandler((KeyHandler)contentProposalHandler);
    }

    public String getContributorId() {
        return ID;
    }

    @Override
    public void dispose() {
        this.validationJob.cancel();
        this.getEditingDomain().removeResourceSetListener(this.validationListener);
        this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.domainAdapter);
        if (this.domainAdapter != null) {
            this.domainAdapter.dispose();
        }
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        try {
            if (editorInput.getFile() != null && editorInput.getFile().exists()) {
                editorInput.getFile().touch((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    public SCTValidationJob getValidationJob() {
        return this.validationJob;
    }
}

