/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Beta
public class EqualsHashCodeProcessor
extends AbstractClassProcessor {
    public void doTransform(MutableClassDeclaration it, final @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        Type _findTypeGlobally = context.findTypeGlobally(Data.class);
        AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        Util util = new Util(context);
        boolean _hasEquals = util.hasEquals((ClassDeclaration)it);
        if (_hasEquals) {
            Type _findTypeGlobally_1 = context.findTypeGlobally(EqualsHashCode.class);
            AnnotationReference annotation = it.findAnnotation(_findTypeGlobally_1);
            context.addWarning((Element)annotation, "equals is already defined, this annotation has no effect");
        } else {
            boolean _hasHashCode = util.hasHashCode((ClassDeclaration)it);
            if (_hasHashCode) {
                context.addWarning((Element)it, "hashCode is already defined, this annotation has no effect");
            } else {
                boolean hasSuperEquals = util.hasSuperEquals((ClassDeclaration)it);
                Iterable _declaredFields = it.getDeclaredFields();
                Functions.Function1<MutableFieldDeclaration, Boolean> _function = new Functions.Function1<MutableFieldDeclaration, Boolean>(){

                    public Boolean apply(MutableFieldDeclaration it) {
                        boolean _isThePrimaryGeneratedJavaElement;
                        boolean _isTransient;
                        boolean _not_1;
                        boolean _not;
                        boolean _and = false;
                        boolean _and_1 = false;
                        boolean _isStatic = it.isStatic();
                        boolean bl = _not = !_isStatic;
                        _and_1 = !_not ? false : (_not_1 = !(_isTransient = it.isTransient()));
                        _and = !_and_1 ? false : (_isThePrimaryGeneratedJavaElement = context.isThePrimaryGeneratedJavaElement((Element)it));
                        return _and;
                    }
                };
                Iterable fields = IterableExtensions.filter((Iterable)_declaredFields, (Functions.Function1)_function);
                util.addEquals(it, fields, hasSuperEquals);
                util.addHashCode(it, fields, hasSuperEquals);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public boolean hasHashCode(ClassDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.findDeclaredMethod("hashCode", new TypeReference[0]);
            return _findDeclaredMethod != null;
        }

        public boolean hasEquals(ClassDeclaration it) {
            Iterable _declaredMethods = it.getDeclaredMethods();
            Functions.Function1<MethodDeclaration, Boolean> _function = new Functions.Function1<MethodDeclaration, Boolean>(){

                public Boolean apply(MethodDeclaration it) {
                    Iterable _parameters;
                    int _size;
                    boolean _equals_1;
                    boolean _and = false;
                    boolean _and_1 = false;
                    String _simpleName = it.getSimpleName();
                    boolean _equals = Objects.equal((Object)_simpleName, (Object)"equals");
                    _and_1 = !_equals ? false : (_equals_1 = (_size = IterableExtensions.size((Iterable)(_parameters = it.getParameters()))) == 1);
                    if (!_and_1) {
                        _and = false;
                    } else {
                        boolean _equals_2;
                        Iterable _parameters_1 = it.getParameters();
                        ParameterDeclaration _head = (ParameterDeclaration)IterableExtensions.head((Iterable)_parameters_1);
                        TypeReference _type = _head.getType();
                        String _name = _type.getName();
                        _and = _equals_2 = Objects.equal((Object)_name, (Object)"java.lang.Object");
                    }
                    return _and;
                }
            };
            return IterableExtensions.exists((Iterable)_declaredMethods, (Functions.Function1)_function);
        }

        public boolean hasSuperEquals(ClassDeclaration cls) {
            TypeReference _object;
            boolean _xifexpression = false;
            TypeReference _newTypeReference = this.context.newTypeReference((Type)cls, new TypeReference[0]);
            boolean _equals = _newTypeReference.equals((Object)(_object = this.context.getObject()));
            if (_equals) {
                _xifexpression = false;
            } else {
                boolean _xifexpression_1 = false;
                boolean _hasEquals = this.hasEquals(cls);
                if (_hasEquals) {
                    _xifexpression_1 = true;
                } else {
                    TypeReference _extendedClass = cls.getExtendedClass();
                    Type _type = _extendedClass.getType();
                    _xifexpression_1 = this.hasSuperEquals((ClassDeclaration)_type);
                }
                _xifexpression = _xifexpression_1;
            }
            return _xifexpression;
        }

        public void addEquals(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _primitiveBoolean = Util.this.context.getPrimitiveBoolean();
                    it.setReturnType(_primitiveBoolean);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    TypeReference _object = Util.this.context.getObject();
                    it.addParameter("obj", _object);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"if (this == obj)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                            _builder.append((Object)"if (obj == null)");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            _builder.append((Object)"if (getClass() != obj.getClass())");
                            _builder.newLine();
                            _builder.append((Object)"  ");
                            _builder.append((Object)"return false;");
                            _builder.newLine();
                            if (includeSuper) {
                                _builder.append((Object)"if (!super.equals(obj))");
                                _builder.newLine();
                                _builder.append((Object)"  ");
                                _builder.append((Object)"return false;");
                                _builder.newLine();
                            }
                            TypeReference _newWildCardSelfTypeReference = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                            _builder.append((Object)_newWildCardSelfTypeReference, "");
                            _builder.append((Object)" other = (");
                            TypeReference _newWildCardSelfTypeReference_1 = Util.this.newWildCardSelfTypeReference((ClassDeclaration)cls);
                            _builder.append((Object)_newWildCardSelfTypeReference_1, "");
                            _builder.append((Object)") obj;");
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : includedFields) {
                                String _contributeToEquals = Util.this.contributeToEquals(field);
                                _builder.append((Object)_contributeToEquals, "");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return true;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("equals", (Procedures.Procedure1)_function);
        }

        private TypeReference newWildCardSelfTypeReference(ClassDeclaration cls) {
            Iterable _typeParameters = cls.getTypeParameters();
            Functions.Function1<TypeParameterDeclaration, TypeReference> _function = new Functions.Function1<TypeParameterDeclaration, TypeReference>(){

                public TypeReference apply(TypeParameterDeclaration it) {
                    TypeReference _object = Util.this.context.getObject();
                    return Util.this.context.newWildcardTypeReference(_object);
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_typeParameters, (Functions.Function1)_function);
            return this.context.newTypeReference((Type)cls, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
        }

        public String contributeToEquals(FieldDeclaration it) {
            String _name_2;
            String _name_1;
            String _switchResult = null;
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            String _name = _orObject.getName();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_1 = Double.TYPE.getName()))) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"if (Double.doubleToLongBits(other.");
                String _simpleName = it.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)") != Double.doubleToLongBits(this.");
                String _simpleName_1 = it.getSimpleName();
                _builder.append((Object)_simpleName_1, "");
                _builder.append((Object)"))");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"  ");
                _builder.append((Object)"return false; ");
                _builder.newLine();
                _switchResult = _builder.toString();
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                _matched = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"if (Float.floatToIntBits(other.");
                String _simpleName_2 = it.getSimpleName();
                _builder_1.append((Object)_simpleName_2, "");
                _builder_1.append((Object)") != Float.floatToIntBits(this.");
                String _simpleName_3 = it.getSimpleName();
                _builder_1.append((Object)_simpleName_3, "");
                _builder_1.append((Object)"))");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append((Object)"  ");
                _builder_1.append((Object)"return false; ");
                _builder_1.newLine();
                _switchResult = _builder_1.toString();
            }
            if (!_matched) {
                String _name_8;
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4;
                String _name_3 = Boolean.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_3)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_4 = Integer.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append((Object)"if (other.");
                    String _simpleName_4 = it.getSimpleName();
                    _builder_2.append((Object)_simpleName_4, "");
                    _builder_2.append((Object)" != this.");
                    String _simpleName_5 = it.getSimpleName();
                    _builder_2.append((Object)_simpleName_5, "");
                    _builder_2.append((Object)")");
                    _builder_2.newLineIfNotEmpty();
                    _builder_2.append((Object)"  ");
                    _builder_2.append((Object)"return false;");
                    _builder_2.newLine();
                    _switchResult = _builder_2.toString();
                }
            }
            if (!_matched) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append((Object)"if (this.");
                String _simpleName_6 = it.getSimpleName();
                _builder_3.append((Object)_simpleName_6, "");
                _builder_3.append((Object)" == null) {");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"  ");
                _builder_3.append((Object)"if (other.");
                String _simpleName_7 = it.getSimpleName();
                _builder_3.append((Object)_simpleName_7, "  ");
                _builder_3.append((Object)" != null)");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"    ");
                _builder_3.append((Object)"return false;");
                _builder_3.newLine();
                _builder_3.append((Object)"} else if (!this.");
                String _simpleName_8 = it.getSimpleName();
                _builder_3.append((Object)_simpleName_8, "");
                _builder_3.append((Object)".equals(other.");
                String _simpleName_9 = it.getSimpleName();
                _builder_3.append((Object)_simpleName_9, "");
                _builder_3.append((Object)"))");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append((Object)"  ");
                _builder_3.append((Object)"return false;");
                _builder_3.newLine();
                _switchResult = _builder_3.toString();
            }
            return _switchResult;
        }

        public void addHashCode(final MutableClassDeclaration cls, final Iterable<? extends FieldDeclaration> includedFields, final boolean includeSuper) {
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(MutableMethodDeclaration it) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)cls);
                    Util.this.context.setPrimarySourceElement((MutableElement)it, _primarySourceElement);
                    TypeReference _primitiveInt = Util.this.context.getPrimitiveInt();
                    it.setReturnType(_primitiveInt);
                    AnnotationReference _newAnnotationReference = Util.this.context.newAnnotationReference(Override.class);
                    it.addAnnotation(_newAnnotationReference);
                    AnnotationReference _newAnnotationReference_1 = Util.this.context.newAnnotationReference(Pure.class);
                    it.addAnnotation(_newAnnotationReference_1);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)"final int prime = 31;");
                            _builder.newLine();
                            _builder.append((Object)"int result = ");
                            if (includeSuper) {
                                _builder.append((Object)"super.hashCode()");
                            } else {
                                _builder.append((Object)"1");
                            }
                            _builder.append((Object)";");
                            _builder.newLineIfNotEmpty();
                            for (FieldDeclaration field : includedFields) {
                                String _contributeToHashCode = Util.this.contributeToHashCode(field);
                                _builder.append((Object)_contributeToHashCode, "");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"return result;");
                            _builder.newLine();
                        }
                    };
                    it.setBody(_client);
                }
            };
            cls.addMethod("hashCode", (Procedures.Procedure1)_function);
        }

        public String contributeToHashCode(FieldDeclaration it) {
            String _name_8;
            String _name_3;
            String _name_2;
            String _name_1;
            String _switchResult = null;
            TypeReference _type = it.getType();
            TypeReference _orObject = this.orObject(_type);
            String _name = _orObject.getName();
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_1 = Double.TYPE.getName()))) {
                _matched = true;
                String _simpleName = it.getSimpleName();
                String _plus = "result = prime * result + (int) (Double.doubleToLongBits(this." + _simpleName;
                String _plus_1 = String.valueOf(_plus) + ") ^ (Double.doubleToLongBits(this.";
                String _simpleName_1 = it.getSimpleName();
                String _plus_2 = String.valueOf(_plus_1) + _simpleName_1;
                _switchResult = String.valueOf(_plus_2) + ") >>> 32));";
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_2 = Float.TYPE.getName()))) {
                _matched = true;
                String _simpleName_2 = it.getSimpleName();
                String _plus_3 = "result = prime * result + Float.floatToIntBits(this." + _simpleName_2;
                _switchResult = String.valueOf(_plus_3) + ");";
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_3 = Boolean.TYPE.getName()))) {
                _matched = true;
                String _simpleName_3 = it.getSimpleName();
                String _plus_4 = "result = prime * result + (this." + _simpleName_3;
                _switchResult = String.valueOf(_plus_4) + " ? 1231 : 1237);";
            }
            if (!_matched) {
                String _name_7;
                String _name_6;
                String _name_5;
                String _name_4 = Integer.TYPE.getName();
                if (Objects.equal((Object)_name, (Object)_name_4)) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_5 = Character.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_6 = Byte.TYPE.getName()))) {
                    _matched = true;
                }
                if (!_matched && Objects.equal((Object)_name, (Object)(_name_7 = Short.TYPE.getName()))) {
                    _matched = true;
                }
                if (_matched) {
                    String _simpleName_4 = it.getSimpleName();
                    String _plus_5 = "result = prime * result + this." + _simpleName_4;
                    _switchResult = String.valueOf(_plus_5) + ";";
                }
            }
            if (!_matched && Objects.equal((Object)_name, (Object)(_name_8 = Long.TYPE.getName()))) {
                _matched = true;
                String _simpleName_5 = it.getSimpleName();
                String _plus_6 = "result = prime * result + (int) (this." + _simpleName_5;
                String _plus_7 = String.valueOf(_plus_6) + " ^ (this.";
                String _simpleName_6 = it.getSimpleName();
                String _plus_8 = String.valueOf(_plus_7) + _simpleName_6;
                _switchResult = String.valueOf(_plus_8) + " >>> 32));";
            }
            if (!_matched) {
                String _simpleName_7 = it.getSimpleName();
                String _plus_9 = "result = prime * result + ((this." + _simpleName_7;
                String _plus_10 = String.valueOf(_plus_9) + "== null) ? 0 : this.";
                String _simpleName_8 = it.getSimpleName();
                String _plus_11 = String.valueOf(_plus_10) + _simpleName_8;
                _switchResult = String.valueOf(_plus_11) + ".hashCode());";
            }
            return _switchResult;
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            boolean _tripleEquals = ref == null;
            _xifexpression = _tripleEquals ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

