/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.ClassifierEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ConstrainedItemBorderLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideClassifierContentsEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ClassifierFigure;
import org.eclipse.papyrus.uml.diagram.profile.custom.figure.StereotypeFigure;
import org.eclipse.papyrus.uml.diagram.profile.custom.policies.CustomGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.profile.custom.policies.itemsemantic.CustomStereotypeItemSemanticEditPolicyCN;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.StereotypeAttributeCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.StereotypeNameEditPartCN;
import org.eclipse.papyrus.uml.diagram.profile.edit.parts.StereotypeOperationCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.profile.edit.policies.StereotypeItemSemanticEditPolicyCN;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.swt.graphics.Color;

public class StereotypeEditPartCN
extends ClassifierEditPart {
    public static final int VISUAL_ID = 1023;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public StereotypeEditPartCN(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new PapyrusCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new StereotypeItemSemanticEditPolicyCN());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("RESIZE_BORDER_ITEMS", (EditPolicy)new ConstrainedItemBorderLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new CustomGraphicalNodeEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomStereotypeItemSemanticEditPolicyCN());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("Show/Hide Classifier Contents Policy", (EditPolicy)new ShowHideClassifierContentsEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null && this.resolveSemanticElement().equals(event.getNotifier()) && event.getFeature() instanceof EAttribute && ((EAttribute)event.getFeature()).getName().equals("isActive")) {
            ((ClassifierFigure)this.getFigure()).setActive(event.getNewBooleanValue());
            this.refreshVisuals();
        }
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new StereotypeFigure();
        return this.primaryShape;
    }

    public StereotypeFigure getPrimaryShape() {
        return (StereotypeFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StereotypeNameEditPartCN) {
            ((StereotypeNameEditPartCN)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof StereotypeAttributeCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((StereotypeAttributeCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof StereotypeOperationCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((StereotypeOperationCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof StereotypeNameEditPartCN) {
            return true;
        }
        if (childEditPart instanceof StereotypeAttributeCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            pane.remove(((StereotypeAttributeCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof StereotypeOperationCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            pane.remove(((StereotypeOperationCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof StereotypeAttributeCompartmentEditPartCN) {
            return this.getPrimaryShape().getAttributeCompartmentFigure();
        }
        if (editPart instanceof StereotypeOperationCompartmentEditPartCN) {
            return this.getPrimaryShape().getOperationCompartmentFigure();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(100, 100);
        return result;
    }

    protected NodeFigure createNodeFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(1046));
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter();
            IElementType type = (IElementType)adapter.getAdapter(IElementType.class);
            if (type == UMLElementTypes.Property_3002) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(1052));
            }
            if (type == UMLElementTypes.Operation_3020) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(1053));
            }
        }
        return super.getTargetEditPart(request);
    }
}

