/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.profile.custom.requests.CustomCreateViewRequest;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLViewProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class CustomMetaClassCreateCommand
extends CreateCommand {
    private static final int HEIGHT_BETWEEN_TWO_METACLASS = 80;
    protected CustomCreateViewRequest.ViewDescriptor myViewDescriptor;
    protected Point location;

    public CustomMetaClassCreateCommand(TransactionalEditingDomain editingDomain, CustomCreateViewRequest.ViewDescriptor descriptor, View containerView, Point location) {
        super(editingDomain, new CreateViewRequest.ViewDescriptor(descriptor.getElementAdapter(), descriptor.getViewKind(), descriptor.getSemanticHint(), true, descriptor.getPreferencesHint()), containerView);
        Assert.isNotNull((Object)containerView);
        this.myViewDescriptor = descriptor;
        this.setLocation(location);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String semanticHint = this.myViewDescriptor.getSemanticHint();
        int iterNbAddedMetaclasses = 0;
        if (!semanticHint.equals(Integer.valueOf(1031).toString()) && !semanticHint.equals(Integer.valueOf(3028).toString())) {
            return super.doExecuteWithResult(monitor, info);
        }
        UMLViewProvider viewProvider = new UMLViewProvider();
        for (CreateElementRequestAdapter adapter : this.myViewDescriptor.getRequestAdapters()) {
            Element UMLelement = (Element)adapter.getAdapter(EObject.class);
            if (UMLelement == null) continue;
            Node node = viewProvider.createNode((IAdaptable)adapter, this.containerView, this.myViewDescriptor.getSemanticHint(), this.myViewDescriptor.getIndex(), this.myViewDescriptor.isPersisted(), this.myViewDescriptor.getPreferencesHint());
            Bounds notationLocation = NotationFactory.eINSTANCE.createBounds();
            notationLocation.setX(this.location.x);
            notationLocation.setY(this.location.y + iterNbAddedMetaclasses++ * 80);
            node.setLayoutConstraint((LayoutConstraint)notationLocation);
            String stereotypeName = ((Stereotype)UMLelement.getAppliedStereotypes().get(0)).getQualifiedName();
            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)this.getEditingDomain(), (EModelElement)node, (String)stereotypeName, (String)"HorizontalStereo");
            command.execute();
        }
        return CommandResult.newOKCommandResult((Object)this.myViewDescriptor);
    }

    public Point getLocation() {
        return this.location;
    }

    public void setLocation(Point location) {
        this.location = location;
    }
}

