/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2m.atl.adt.ui.AtlPreferenceConstants;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.m2m.atl.adt.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.osgi.framework.BundleContext;

public class AtlUIPlugin
extends AbstractUIPlugin {
    private static final String ID = "org.eclipse.m2m.atl.adt.editor";
    private static AtlUIPlugin plugin;
    private AtlTextTools atlTextTools;
    private ProblemMarkerManager problemMarkerManager;
    private ResourceBundle resourceBundle;

    public AtlUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.m2m.atl.adt.ui.AtlUIPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.problemMarkerManager == null) {
            this.problemMarkerManager = new ProblemMarkerManager();
        }
        return this.problemMarkerManager;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized AtlTextTools getTextTools() {
        if (this.atlTextTools == null) {
            this.atlTextTools = new AtlTextTools(this.getPreferenceStore());
        }
        return this.atlTextTools;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        MarkerAnnotationPreferences.initializeDefaultValues((IPreferenceStore)store);
        AtlPreferenceConstants.initializeDefaultValues(store);
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.atlTextTools != null) {
                this.atlTextTools.dispose();
                this.atlTextTools = null;
            }
        }
        finally {
            super.stop(context);
        }
    }

    public Image getImage(String path) {
        ImageRegistry registry = AtlUIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ImageDescriptor desc = AtlUIPlugin.imageDescriptorFromPlugin((String)AtlUIPlugin.getPluginId(), (String)path);
            registry.put(path, desc);
            image = registry.get(path);
        }
        return image;
    }

    public static IWorkbenchPage getActivePage() {
        return AtlUIPlugin.getDefault().internalGetActivePage();
    }

    public static AtlUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        AtlUIPlugin uiPlugin = AtlUIPlugin.getDefault();
        String pluginDir = uiPlugin.getBundle().getEntry("/").toString();
        String iconPath = "icons/";
        try {
            return ImageDescriptor.createFromURL((URL)new URL(String.valueOf(pluginDir) + iconPath + name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static String getPluginId() {
        return ID;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AtlUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }
}

