/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.ide.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterPackagesAction;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.internal.ide.actions.OpenResourcesDialog;
import org.eclipse.emf.cdo.ui.internal.ide.messages.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterWorkspacePackagesAction
extends RegisterPackagesAction {
    private static final String TITLE = Messages.getString("RegisterWorkspacePackagesAction.0");
    private static final String TOOL_TIP = Messages.getString("RegisterWorkspacePackagesAction.1");

    public RegisterWorkspacePackagesAction(IWorkbenchPage page, CDOSession session) {
        super(page, TITLE, TOOL_TIP, null, session);
    }

    protected List<EPackage> getEPackages(IWorkbenchPage page, CDOSession session) {
        Object[] result;
        Shell shell = page.getWorkbenchWindow().getShell();
        OpenResourcesDialog dialog = new OpenResourcesDialog(shell);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length != 0) {
            ResourceSet resourceSet = EMFUtil.newEcoreResourceSet();
            resourceSet.getURIConverter().getURIMap().putAll(RegisterWorkspacePackagesAction.computePlatformURIMap());
            ArrayList<EPackage> ePackages = new ArrayList<EPackage>(result.length);
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IFile) {
                    IFile file = (IFile)object;
                    URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    Resource resource = resourceSet.getResource(uri, true);
                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                    ePackages.add(ePackage);
                }
                ++n2;
            }
            return ePackages;
        }
        return null;
    }

    private static Map<URI, URI> computePlatformURIMap() {
        try {
            return EcorePlugin.computePlatformURIMap((boolean)true);
        }
        catch (Throwable ex) {
            return EcorePlugin.computePlatformURIMap();
        }
    }
}

