/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.gmf.runtime.editparts;

import com.google.common.base.Preconditions;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;

public final class GraphicalHelper {
    private GraphicalHelper() {
    }

    public static double getZoom(IGraphicalEditPart part) {
        Preconditions.checkNotNull((Object)part);
        double scale = 1.0;
        if (part.getRoot() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEditPart = (DiagramRootEditPart)part.getRoot();
            scale = rootEditPart.getZoomManager().getZoom();
        }
        return scale;
    }

    public static void appliedZoomOnRelativePoint(IGraphicalEditPart part, Point relativePoint) {
        double zoom = GraphicalHelper.getZoom(part);
        relativePoint.setLocation((int)((double)relativePoint.x / zoom), (int)((double)relativePoint.y / zoom));
    }

    public static void setZoom(IGraphicalEditPart part, double scale) {
        Preconditions.checkNotNull((Object)part);
        if (part.getRoot() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEditPart = (DiagramRootEditPart)part.getRoot();
            rootEditPart.getZoomManager().setZoom(scale);
        }
    }

    public static Point getScrollSize(IGraphicalEditPart part) {
        Preconditions.checkNotNull((Object)part);
        FreeformViewport viewport = FigureUtilities.getFreeformViewport((IFigure)part.getFigure());
        if (viewport != null) {
            return viewport.getViewLocation();
        }
        return new Point(0, 0);
    }

    public static void setScrollSize(IGraphicalEditPart part, Point scrollPosition) {
        Preconditions.checkNotNull((Object)part);
        if (part.getViewer().getControl() instanceof FigureCanvas) {
            ((FigureCanvas)part.getViewer().getControl()).scrollTo(scrollPosition.x, scrollPosition.y);
        }
    }

    public static void screen2logical(Point point, IGraphicalEditPart part) {
        point.translate(GraphicalHelper.getScrollSize(part));
        point.performScale(1.0 / GraphicalHelper.getZoom(part));
    }

    public static void screen2logical(Rectangle rect, IGraphicalEditPart part) {
        rect.translate(GraphicalHelper.getScrollSize(part));
        rect.performScale(1.0 / GraphicalHelper.getZoom(part));
    }

    public static void screen2logical(Dimension dim, IGraphicalEditPart part) {
        dim.performScale(1.0 / GraphicalHelper.getZoom(part));
    }

    public static void logical2screen(Point point, IGraphicalEditPart part) {
        point.performScale(GraphicalHelper.getZoom(part));
        point.translate(GraphicalHelper.getScrollSize(part).negate());
    }

    public static void logical2screen(Rectangle rect, IGraphicalEditPart part) {
        rect.performScale(GraphicalHelper.getZoom(part));
        rect.translate(GraphicalHelper.getScrollSize(part).negate());
    }

    public static void logical2Screen(Dimension dim, IGraphicalEditPart part) {
        dim.performScale(GraphicalHelper.getZoom(part));
    }
}

