/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.contributor;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Type;

public class TypedNavigableElement
implements NavigableElement {
    protected final Type type;

    public TypedNavigableElement(Type type) {
        this.type = type;
    }

    public String getLabel() {
        String label = "Go to type" + this.getTypeLabel();
        return label;
    }

    public String getDescription() {
        return "Go to the type declaration of this TypedElement" + this.getTypeLabel();
    }

    protected String getTypeLabel() {
        if (this.type == null) {
            return " (Undefined)";
        }
        return " (" + this.type.getName() + ")";
    }

    @Deprecated
    public void navigate(IRevealSemanticElement navigationContext) {
        if (!this.isEnabled()) {
            return;
        }
        navigationContext.revealSemanticElement(Collections.singletonList(this.type));
    }

    public Image getImage() {
        if (this.type == null) {
            return null;
        }
        try {
            return ((LabelProviderService)ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.type).getService(LabelProviderService.class)).getLabelProvider().getImage((Object)this.type);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isEnabled() {
        return this.type != null;
    }

    public boolean navigate(NavigationTarget navigationContext) {
        if (!this.isEnabled()) {
            return false;
        }
        return navigationContext.revealElement((Object)this.type);
    }
}

