/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerTabExtension;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.DeleteActionHandler;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.ModelExplorerView;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;

public class CommonNavigatorTab
implements IModelExplorerTabExtension {
    public static final String TAB_ID = "navigator";
    private static final String MODEL_EXPLORER_STRUCTURE_TAB_NAME = "Navigator";
    private static final String MODEL_EXPLORER_STRUCTURE_TAB_ICON = "icons/full/others/structure.gif";
    private ModelExplorerView view;
    private Action deleteActionHandler;

    public CommonNavigatorTab(ModelExplorerView view) {
        this.view = view;
    }

    @Override
    public void init(IViewSite site) {
    }

    @Override
    public Control createTabControl(CTabFolder tabFolder) {
        this.view.createNavigatorControl(tabFolder);
        this.hookGlobalActions();
        Control control = this.view.getCommonViewer().getControl();
        while (control != null && control.getParent() != tabFolder) {
            control = control.getParent();
        }
        return control;
    }

    private void hookGlobalActions() {
        IActionBars bars = this.view.getViewSite().getActionBars();
        this.deleteActionHandler = new DeleteActionHandler(this.view.getSite().getSelectionProvider());
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteActionHandler);
        this.view.getCommonViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && CommonNavigatorTab.this.deleteActionHandler.isEnabled()) {
                    CommonNavigatorTab.this.deleteActionHandler.run();
                }
            }
        });
        bars.updateActionBars();
    }

    @Override
    public String getToolTipText() {
        return MODEL_EXPLORER_STRUCTURE_TAB_NAME;
    }

    @Override
    public Iterable<IAction> getActions() {
        LinkedHashSet actions = Sets.newLinkedHashSet();
        return actions;
    }

    public Image getImage() {
        return SiriusEditPlugin.getPlugin().getBundledImage(MODEL_EXPLORER_STRUCTURE_TAB_ICON);
    }

    @Override
    public void dispose() {
        this.view = null;
    }
}

