/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.common.ui.tools.api.view.IExpandSelectionTarget;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerTabExtension;
import org.eclipse.sirius.ui.tools.api.views.modelexplorerview.IModelExplorerView;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.filter.FilteredCommonTree;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.DeleteActionHandler;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.ModelExplorerItemComparer;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.RenameActionHandler;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab.CommonNavigatorTab;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab.ModelExplorerTabDescriptor;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab.ModelExplorerTabRegistry;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ModelExplorerView
extends CommonNavigator
implements IModelExplorerView,
IExpandSelectionTarget,
ITabbedPropertySheetPageContributor {
    private CTabFolder tabFolder;
    private String initialSelection = "";
    private Map<CTabItem, TabInfo> tabItems = Maps.newLinkedHashMap();
    private Action deleteActionHandler;
    private Action renameActionHandler;

    public void createPartControl(Composite aParent) {
        aParent.setLayout((Layout)new FillLayout(256));
        Collection<ModelExplorerTabDescriptor> tabDescriptors = ModelExplorerTabRegistry.getRegisteredExtensions();
        if (tabDescriptors.isEmpty()) {
            super.createPartControl(aParent);
            this.hookGlobalActions();
        } else {
            this.tabFolder = new CTabFolder(aParent, 2048);
            this.tabFolder.setBorderVisible(false);
            this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.selection(e);
                }

                private void selection(SelectionEvent e) {
                    CTabItem tabItem = ModelExplorerView.this.tabFolder.getSelection();
                    TabInfo tabInfo = (TabInfo)ModelExplorerView.this.tabItems.get(tabItem);
                    IModelExplorerTabExtension tab = tabInfo.tab;
                    if (tab != null) {
                        IToolBarManager mgr = ModelExplorerView.this.getViewSite().getActionBars().getToolBarManager();
                        for (IAction action : tab.getActions()) {
                            mgr.add(action);
                        }
                        mgr.update(true);
                    }
                }
            });
            this.createTabs(tabDescriptors);
        }
        this.getCommonViewer().setComparer((IElementComparer)new ModelExplorerItemComparer());
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public void createNavigatorControl(CTabFolder folder) {
        super.createPartControl((Composite)folder);
    }

    public void refreshNavigatorInput() {
        this.getCommonViewer().setInput(this.getInitialInput());
    }

    private void createTabs(Collection<ModelExplorerTabDescriptor> tabDescriptors) {
        LinkedHashSet tabs = Sets.newLinkedHashSet();
        CommonNavigatorTab navigatorTab = new CommonNavigatorTab(this);
        tabs.add(new TabInfo("navigator", navigatorTab.getImage(), navigatorTab));
        for (ModelExplorerTabDescriptor tabDescriptor : tabDescriptors) {
            IModelExplorerTabExtension tab = tabDescriptor.getTabExtension();
            Image tabImage = SiriusEditPlugin.getPlugin().getImage(tabDescriptor.getImageDescriptor());
            if (tab == null || tabImage == null) continue;
            TabInfo tabInfo = new TabInfo(tabDescriptor.getId(), tabImage, tab);
            tabs.add(tabInfo);
        }
        this.createTabItems(tabs);
    }

    private void createTabItems(Collection<TabInfo> tabs) {
        for (TabInfo tabInfo : tabs) {
            IModelExplorerTabExtension tab = tabInfo.tab;
            Image tabImage = tabInfo.image;
            Control tabControl = tab.createTabControl(this.tabFolder);
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            tabItem.setControl(tabControl);
            tabItem.setToolTipText(tab.getToolTipText());
            tabItem.setImage(tabImage);
            this.tabItems.put(tabItem, tabInfo);
            if (StringUtil.isEmpty((String)tabInfo.id) || !tabInfo.id.equals(this.initialSelection)) continue;
            this.tabFolder.setSelection(tabItem);
        }
    }

    public void saveState(IMemento aMemento) {
        CTabItem selection;
        super.saveState(aMemento);
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()) != null) {
            TabInfo tabInfo = this.tabItems.get(selection);
            aMemento.putString("org.eclipse.sirius.ui.modelExplorerTabExtension", tabInfo.id);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        for (ModelExplorerTabDescriptor tabDescriptor : ModelExplorerTabRegistry.getRegisteredExtensions()) {
            IModelExplorerTabExtension tab = tabDescriptor.getTabExtension();
            if (tab == null) continue;
            tab.init(site);
        }
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        String selectedTabId;
        super.init(aSite, aMemento);
        this.initialSelection = "navigator";
        if (aMemento != null && !StringUtil.isEmpty((String)(selectedTabId = aMemento.getString("org.eclipse.sirius.ui.modelExplorerTabExtension")))) {
            this.initialSelection = selectedTabId;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.tabFolder != null) {
            this.tabFolder.dispose();
            this.tabFolder = null;
        }
        this.tabItems.clear();
        for (ModelExplorerTabDescriptor tabDescriptor : ModelExplorerTabRegistry.getRegisteredExtensions()) {
            IModelExplorerTabExtension tab = tabDescriptor.getTabExtension();
            if (tab == null) continue;
            tab.dispose();
        }
    }

    public void expand(Object elementOrTreePath) {
        if (this.getCommonViewer() != null) {
            this.getCommonViewer().expandToLevel(elementOrTreePath, 1);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite parent) {
        FilteredCommonTree commonfilteredTree = new FilteredCommonTree(this.getViewSite().getId(), parent, 770, false);
        SWTUtil.addDisposeListener((Composite)parent, (Composite)commonfilteredTree);
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.grabExcessVerticalSpace = true;
        commonfilteredTree.setLayoutData(gridData3);
        return commonfilteredTree.getViewer();
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        Option optionalMainSessionFileURI;
        Option optionalModelingProject;
        super.handleDoubleClick(anEvent);
        IStructuredSelection selection = (IStructuredSelection)anEvent.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IProject && (optionalModelingProject = ModelingProject.asModelingProject((IProject)((IProject)element))).some() && (optionalMainSessionFileURI = ((ModelingProject)optionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)new NullProgressMonitor(), false, false)).some()) {
            ModelingProjectManager.INSTANCE.loadAndOpenRepresentationsFile((URI)optionalMainSessionFileURI.get());
        }
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.deleteActionHandler = new DeleteActionHandler(this.getSite().getSelectionProvider());
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteActionHandler);
        this.renameActionHandler = new RenameActionHandler(this.getSite().getSelectionProvider());
        bars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameActionHandler);
        this.getCommonViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ModelExplorerView.this.handleKeyReleased(event);
            }
        });
        bars.updateActionBars();
    }

    private void handleKeyReleased(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
        if (key == 127) {
            if (this.deleteActionHandler.isEnabled()) {
                this.deleteActionHandler.run();
            }
        } else if (key == 0x100000B && this.renameActionHandler.isEnabled()) {
            this.renameActionHandler.run();
        }
    }

    public String getContributorId() {
        return "org.eclipse.sirius.ui.tools.views.model.explorer";
    }

    private class TabInfo {
        final String id;
        final Image image;
        final IModelExplorerTabExtension tab;

        public TabInfo(String id, Image image, IModelExplorerTabExtension tab) {
            this.id = id;
            this.image = image;
            this.tab = tab;
        }
    }
}

