/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.repair;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.repair.SiriusRepairProcess;
import org.eclipse.sirius.ui.tools.internal.actions.repair.RepresentationFilesRepairValidator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class RepresentationFilesRepairAction
extends ActionDelegate {
    private static final String MSG_REPAIR_ERROR = "Repair error";
    private static final String MSG_REPAIR_INTERRUPTED = "Repair interrupted";
    protected IFile file;

    public void run(IAction action) {
        if (this.file != null) {
            try {
                IStatus validationStatus = new RepresentationFilesRepairValidator().validate(this.file);
                if (validationStatus.isOK()) {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            SiriusRepairProcess process = new SiriusRepairProcess(RepresentationFilesRepairAction.this.file, true);
                            process.run(monitor);
                            process.dispose();
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                this.dispose();
                Status status = new Status(4, "org.eclipse.sirius", "Could not run repair process.", e.getCause());
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)MSG_REPAIR_ERROR, (String)MSG_REPAIR_ERROR, (IStatus)status);
                SiriusPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                this.dispose();
                Status status = new Status(2, "org.eclipse.sirius", e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)MSG_REPAIR_INTERRUPTED, (String)MSG_REPAIR_INTERRUPTED, (IStatus)status);
                SiriusPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.file = null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)object;
        }
    }
}

