/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.api.actions.analysis.IAddModelDependencyWizard;
import org.eclipse.sirius.ui.tools.internal.actions.analysis.IAddModelDependencyWizardRegistry;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateOrAddResourceWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AddSemanticResourceAction
extends Action {
    private Collection<URI> sessionsURI = Sets.newLinkedHashSet();

    public AddSemanticResourceAction(List<Session> sessions) {
        this(AddSemanticResourceAction.collectURIsFromSessions(sessions));
    }

    public AddSemanticResourceAction(Collection<URI> sessionsURIs) {
        super("Add Model");
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/add.gif");
        this.setImageDescriptor(descriptor);
        this.sessionsURI = sessionsURIs;
    }

    public void run() {
        super.run();
        ArrayList sessions = Lists.newArrayList();
        for (URI sessionURI : this.sessionsURI) {
            Session session = SessionManager.INSTANCE.getExistingSession(sessionURI);
            if (session == null) continue;
            sessions.add(session);
        }
        IAddModelDependencyWizard wizard = IAddModelDependencyWizardRegistry.getCreateOrAddModelDependencyWizard(sessions);
        if (wizard == null) {
            wizard = new CreateOrAddResourceWizard();
        }
        wizard.setSessions(sessions);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(wizard.getWizardTitle());
        dialog.open();
        this.sessionsURI.clear();
    }

    private static Collection<URI> collectURIsFromSessions(List<Session> sessions) {
        LinkedHashSet sessionsURIs = Sets.newLinkedHashSet();
        for (Session concernedSession : sessions) {
            sessionsURIs.add(concernedSession.getSessionResource().getURI());
        }
        return sessionsURIs;
    }
}

