/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.dialogs;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.dialogs.AbstractExportRepresentationsAsImagesDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExportSeveralRepresentationsAsImagesDialog
extends AbstractExportRepresentationsAsImagesDialog {
    private static final String DIALOG_SETTINGS_FOLDER = "ExportRepresentationsAsImagesDialog.folder";
    private static final String DIRECTORY_DIALOG_MESSAGE = "Select the destination folder";
    private static final String DIRECTORY_DIALOG_TEXT = "Select the destination folder";
    private static final String TO_DIRECTORY = "To directory";
    private static final String DIALOG_TITLE = "Export representations as image file";

    public ExportSeveralRepresentationsAsImagesDialog(Shell shell, IPath path) {
        super(shell, path);
        this.initDialogSettings(path);
    }

    @Override
    protected void handleBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
        dialog.setMessage("Select the destination folder");
        dialog.setText("Select the destination folder");
        String dirName = this.folderText.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.folderText.setText(selectedDirectory);
        }
    }

    @Override
    protected void createFolderGroup(Composite parent) {
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)4, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)TO_DIRECTORY);
        this.folderText = new Combo(composite, 2052);
        this.restoreWidgetValues();
        this.folderText.setText(this.folder);
        GridData gridData = new GridData(768);
        gridData.widthHint = 350;
        this.folderText.setLayoutData((Object)gridData);
        Button button = new Button(composite, 8);
        button.setText("&Browse...");
        button.setLayoutData((Object)AbstractExportRepresentationsAsImagesDialog.makeButtonData(button));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportSeveralRepresentationsAsImagesDialog.this.handleBrowseButtonPressed();
            }
        });
    }

    @Override
    protected void createImageFormatGroup(Composite parent) {
        Label imageFormatControl;
        Composite composite = SWTUtil.createCompositeHorizontalFill((Composite)parent, (int)3, (boolean)false);
        SWTUtil.createLabel((Composite)composite, (String)"&Image Format:");
        String[] imageSafeFormatItems = this.getImageSafeFormatItems();
        if (imageSafeFormatItems != null && imageSafeFormatItems.length > 0) {
            if (imageSafeFormatItems.length == 1) {
                imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)imageSafeFormatItems[0]);
            } else {
                this.imageFormatCombo = new Combo(composite, 12);
                this.imageFormatCombo.setItems(imageSafeFormatItems);
                this.imageFormatCombo.setText(this.imageFormat.getName());
                imageFormatControl = this.imageFormatCombo;
            }
        } else {
            imageFormatControl = SWTUtil.createLabel((Composite)composite, (String)DEFAULT_VALUE.getName());
        }
        GridData gridData = new GridData(4, 0x1000000, true, true);
        imageFormatControl.setLayoutData((Object)gridData);
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    @Override
    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(DIALOG_SETTINGS_FOLDER);
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.folder = directoryNames[0];
            String[] stringArray = directoryNames;
            int n = directoryNames.length;
            int n2 = 0;
            while (n2 < n) {
                String directoryName = stringArray[n2];
                this.folderText.add(directoryName);
                ++n2;
            }
        }
    }

    @Override
    protected void initDialogSettings(IPath path) {
        String persistentImageFormat;
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.folder = "/";
        if (path == null) {
            String persistentFolder = dialogSettings.get(DIALOG_SETTINGS_FOLDER);
            if (persistentFolder != null) {
                this.folder = persistentFolder;
            }
        } else {
            this.folder = path.toOSString();
        }
        this.imageFormat = (persistentImageFormat = dialogSettings.get("ExportRepresentationsAsImagesDialog.imageFormat")) == null ? AbstractExportRepresentationsAsImagesDialog.getDefaultImageFormat() : AbstractExportRepresentationsAsImagesDialog.resolveImageFormat(persistentImageFormat);
    }

    @Override
    protected void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            String[] directoryNames = dialogSettings.getArray(DIALOG_SETTINGS_FOLDER);
            if (directoryNames == null || directoryNames.length == 0) {
                directoryNames = new String[]{this.folder};
            }
            directoryNames = this.addToHistory(directoryNames, this.folder);
            dialogSettings.put(DIALOG_SETTINGS_FOLDER, directoryNames);
            dialogSettings.put("ExportRepresentationsAsImagesDialog.imageFormat", this.imageFormat.getName());
        }
    }

    @Override
    protected void validateFolderText() {
        super.validateFolderText();
        File file = new File(this.folderText.getText());
        if (!file.exists()) {
            this.setDialogErrorState("Folder does not exist");
            return;
        }
    }

    @Override
    protected void initListeners() {
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportSeveralRepresentationsAsImagesDialog.this.validateFolderText();
            }
        });
        this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportSeveralRepresentationsAsImagesDialog.this.imageFormat = AbstractExportRepresentationsAsImagesDialog.resolveImageFormat(ExportSeveralRepresentationsAsImagesDialog.this.imageFormatCombo.getSelectionIndex());
            }
        });
    }
}

