/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.viewpoint;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ViewpointSelectionCallback
implements ViewpointSelection.Callback {
    @Override
    public void selectViewpoint(Viewpoint viewpoint, Session session, IProgressMonitor monitor) {
        this.selectViewpoint(viewpoint, session, true, monitor);
    }

    @Override
    public void selectViewpoint(Viewpoint viewpoint, Session session, boolean createNewRepresentations, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Viewpoint selection : " + viewpoint.getName(), 3);
            Viewpoint editingDomainViewpoint = SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)viewpoint);
            boolean newView = false;
            if (editingDomainViewpoint != null && !SiriusResourceHelper.isViewExistForSirius((Session)session, (Viewpoint)editingDomainViewpoint) && !session.getSemanticResources().isEmpty()) {
                ArrayList roots = Lists.newArrayList();
                for (Resource resource : session.getSemanticResources()) {
                    if (resource == null) continue;
                    roots.addAll(resource.getContents());
                }
                session.createView(editingDomainViewpoint, (Collection)roots, createNewRepresentations, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                DialectManager.INSTANCE.updateRepresentationsExtendedBy(session, editingDomainViewpoint, true);
                newView = true;
            }
            for (DView view : session.getOwnedViews()) {
                if (view.getViewpoint() != null && view.getViewpoint().eResource() != null) continue;
                session.removeSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                DialectManager.INSTANCE.updateRepresentationsExtendedBy(session, editingDomainViewpoint, false);
            }
            if (!newView) {
                for (DView view : session.getOwnedViews()) {
                    if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)viewpoint) || session.getSelectedViewpoints(false).contains(view.getViewpoint())) continue;
                    session.addSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    DialectManager.INSTANCE.updateRepresentationsExtendedBy(session, editingDomainViewpoint, true);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deselectViewpoint(Viewpoint deselectedViewpoint, Session session, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Viewpoint deselection : " + deselectedViewpoint.getName(), 1);
            for (DView view : session.getSelectedViews()) {
                if (view.getViewpoint() == null || !EqualityHelper.areEquals((EObject)view.getViewpoint(), (EObject)deselectedViewpoint)) continue;
                session.removeSelectedView(view, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                Viewpoint editingDomainViewpoint = SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)deselectedViewpoint);
                DialectManager.INSTANCE.updateRepresentationsExtendedBy(session, editingDomainViewpoint, false);
            }
        }
        finally {
            monitor.done();
        }
    }
}

