/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.MetamodelHandlerManager;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.actions.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.EObjectNode;
import org.eclipse.m2m.internal.qvt.oml.trace.TracePackage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;

public class OpenEObjectAction
extends Action {
    private final IWorkbenchPage myPage;
    private final Tree myTree;

    public OpenEObjectAction(IWorkbenchPage page, Tree tree) {
        this.myPage = page;
        this.myTree = tree;
    }

    public void run() {
        TreeItem[] selection;
        TreeItem[] treeItemArray = selection = this.myTree.getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof EObjectNode) {
                EObjectNode eObjectNode = (EObjectNode)data;
                EObject eObject = eObjectNode.getObject();
                if (EcoreUtil.getRootContainer((EObject)eObject).eClass().eContainer() == TracePackage.eINSTANCE) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.OpenEObjectAction_UnboundObjectTitle, (String)NLS.bind((String)Messages.OpenEObjectAction_UnboundObjectMsg, (Object)QvtOperationalTypesUtil.getTypeFullName((EClassifier)eObject.eClass())));
                    return;
                }
                EPackage ePackage = eObject.eClass().getEPackage();
                String nsURI = EmfUtil.getRootPackage((EPackage)ePackage).getNsURI();
                IMetamodelHandler handler = MetamodelHandlerManager.getInstance().getHandler(nsURI);
                try {
                    handler.getSaver().select(eObject, this.myPage);
                }
                catch (Exception e) {
                    Logger.getLogger().log(Logger.SEVERE, "Failed to select " + eObject + " using " + handler, e);
                }
            }
            ++n2;
        }
    }

    private Shell getShell() {
        return this.myPage.getActiveEditor().getSite().getShell();
    }
}

