/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.gmf.proposals;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import de.itemis.xtext.utils.gmf.proposals.ISemanticContentProposal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public abstract class AbstractSemanticContentProposalProvider
implements IContentProposalProvider {
    private ListBasedProposalAcceptor acceptor;
    private GraphicalViewer viewer;

    public abstract void createProposals(IProposalAcceptor var1);

    public AbstractSemanticContentProposalProvider(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.acceptor = new ListBasedProposalAcceptor();
        this.createProposals(this.acceptor);
    }

    public final ISemanticContentProposal[] getProposals(String contents, int position) {
        if (this.viewer.getSelectedEditParts().size() <= 0) {
            return new ISemanticContentProposal[0];
        }
        final IGraphicalEditPart selectedEditPart = (IGraphicalEditPart)this.viewer.getSelectedEditParts().get(0);
        Iterable validProposals = Iterables.filter(this.acceptor.getAllProposals(), (Predicate)new Predicate<ISemanticContentProposal>(){

            public boolean apply(ISemanticContentProposal input) {
                return input.getSemanticModification().IsModificationFor(selectedEditPart.getNotationView());
            }
        });
        if (Iterables.size((Iterable)validProposals) == 0) {
            return new ISemanticContentProposal[0];
        }
        return (ISemanticContentProposal[])Iterables.toArray((Iterable)validProposals, ISemanticContentProposal.class);
    }

    public ISemanticContentProposal getProposal(final String id) {
        return (ISemanticContentProposal)Iterables.find(this.acceptor.getAllProposals(), (Predicate)new Predicate<ISemanticContentProposal>(){

            public boolean apply(ISemanticContentProposal input) {
                return id.equals(input.getID());
            }
        });
    }

    public static interface IProposalAcceptor {
        public void accept(ISemanticContentProposal var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListBasedProposalAcceptor
    implements IProposalAcceptor {
        private List<ISemanticContentProposal> allProposals = new ArrayList<ISemanticContentProposal>();

        @Override
        public void accept(ISemanticContentProposal proposal) {
            this.allProposals.add(proposal);
        }

        public List<ISemanticContentProposal> getAllProposals() {
            return this.allProposals;
        }
    }
}

