/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.gmf.directedit;

import de.itemis.xtext.utils.gmf.directedit.IXtextAwareEditPart;
import de.itemis.xtext.utils.gmf.directedit.XtextDirectEditManager;
import de.itemis.xtext.utils.gmf.figures.HighlightingWrappingLabel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public abstract class ExternalXtextLabelEditPart
extends LabelEditPart
implements IXtextAwareEditPart {
    protected abstract DirectEditManager createDirectEditManager();

    public ExternalXtextLabelEditPart(View view) {
        super(view);
    }

    protected IFigure createFigure() {
        HighlightingWrappingLabel label = new HighlightingWrappingLabel();
        label.setTextWrap(true);
        label.setAlignment(9);
        return label;
    }

    public WrappingLabel getFigure() {
        return (WrappingLabel)super.getFigure();
    }

    public void setLabelText(String text) {
        this.getFigure().setText(text);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFont();
        this.refreshFontColor();
        this.updateLabelText();
    }

    protected void updateLabelText() {
        this.getFigure().setText(this.getEditText());
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getNotifier() instanceof ShapeStyle) {
            this.refreshVisuals();
        } else if (NotationPackage.eINSTANCE.getFontStyle().getEAllAttributes().contains(notification.getFeature())) {
            this.refreshFont();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    public DragTracker getDragTracker(final Request request) {
        return new DragEditPartsTrackerEx((EditPart)this){

            protected boolean isMove() {
                return true;
            }

            protected boolean handleDoubleClick(int button) {
                ExternalXtextLabelEditPart.this.performDirectEditRequest(request);
                return super.handleDoubleClick(button);
            }
        };
    }

    protected void performDirectEditRequest(Request request) {
        final DirectEditManager manager = this.createDirectEditManager();
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    if (ExternalXtextLabelEditPart.this.isActive()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            if (manager instanceof XtextDirectEditManager) {
                                ((XtextDirectEditManager)manager).show(initialChar.charValue());
                            } else if (manager instanceof TextDirectEditManager) {
                                ((TextDirectEditManager)manager).show(initialChar.charValue());
                            }
                        } else {
                            manager.show();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

