/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.gmf.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;

public class AdjustIdentityAnchorCommand
extends AbstractTransactionalCommand {
    private ChangeBoundsRequest request;
    private List<IGraphicalEditPart> editParts;
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';

    public AdjustIdentityAnchorCommand(TransactionalEditingDomain domain, ChangeBoundsRequest request) {
        super(domain, "Adjusting anchors", null);
        this.request = request;
        this.editParts = request.getEditParts();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        for (EditPart editPart : this.editParts) {
            this.adjustAnchors(editPart);
        }
        return CommandResult.newOKCommandResult();
    }

    private void adjustAnchors(EditPart editPart) {
        if (editPart instanceof IGraphicalEditPart) {
            View view = ((IGraphicalEditPart)editPart).getNotationView();
            EList targetEdges = view.getTargetEdges();
            for (Edge edge : targetEdges) {
                Anchor targetAnchor = edge.getTargetAnchor();
                if (!(targetAnchor instanceof IdentityAnchor)) continue;
                PrecisionPoint anchorPoint = BaseSlidableAnchor.parseTerminalString((String)((IdentityAnchor)targetAnchor).getId());
                IFigure figure = ((IGraphicalEditPart)editPart).getFigure();
                Dimension sizeBefore = figure.getBounds().getSize();
                float widthFactor = (float)(sizeBefore.width() + this.request.getSizeDelta().width()) / (float)sizeBefore.width();
                float heightFactor = (float)(sizeBefore.height() + this.request.getSizeDelta().height()) / (float)sizeBefore.height();
                PrecisionPoint newPoint = new PrecisionPoint(anchorPoint.preciseX() / (double)widthFactor, anchorPoint.preciseY() / (double)heightFactor);
                ((IdentityAnchor)targetAnchor).setId(this.composeTerminalString(newPoint));
            }
        }
    }

    protected String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX());
        s.append(',');
        s.append(p.preciseY());
        s.append(')');
        return s.toString();
    }
}

