/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.utilities;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIid;
import org.eclipse.ocl.examples.pivot.utilities.AS2XMIidVisitor;

public class CompleteOCLAS2XMIidVisitor
extends AS2XMIidVisitor {
    public CompleteOCLAS2XMIidVisitor(@NonNull AS2XMIid context) {
        super(context);
    }

    private void appendDisambiguator(@NonNull NamedElement object) {
        EObject eContainer = object.eContainer();
        if (eContainer != null) {
            int index = 0;
            String objectName = object.getName();
            Object siblings = eContainer.eGet((EStructuralFeature)object.eContainmentFeature());
            if (siblings instanceof List) {
                for (Object sibling : (List)siblings) {
                    String siblingName;
                    if (sibling == object) break;
                    if (!(sibling instanceof NamedElement) || !DomainUtil.safeEquals((Object)objectName, (Object)(siblingName = ((NamedElement)sibling).getName()))) continue;
                    ++index;
                }
            }
            this.s.append("." + index);
        }
    }

    @Nullable
    public Boolean visitClass(@NonNull Class object) {
        Boolean status = super.visitClass(object);
        if (status != Boolean.TRUE) {
            return status;
        }
        this.appendDisambiguator((NamedElement)object);
        return true;
    }

    @Nullable
    public Boolean visitEnumeration(@NonNull Enumeration object) {
        Boolean status = (Boolean)super.visitEnumeration(object);
        if (status != Boolean.TRUE) {
            return status;
        }
        this.appendDisambiguator((NamedElement)object);
        return true;
    }

    @Nullable
    public Boolean visitPrimitiveType(@NonNull PrimitiveType object) {
        Boolean status = super.visitPrimitiveType(object);
        if (status != Boolean.TRUE) {
            return status;
        }
        this.appendDisambiguator((NamedElement)object);
        return true;
    }
}

