/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.cs2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ImportCS;
import org.eclipse.ocl.examples.xtext.base.basecs.LibraryCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ParameterCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.basecs.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.basecs.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2as.Continuation;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.ClassifierContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.CompleteOCLDocumentCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.DefOperationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.DefPropertyCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.IncludeCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.OperationContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.PackageDeclarationCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.PropertyContextDeclCS;
import org.eclipse.ocl.examples.xtext.completeocl.completeoclcs.util.AbstractCompleteOCLCSContainmentVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.ExpSpecificationCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLCSContainmentVisitor
extends AbstractCompleteOCLCSContainmentVisitor {
    private Map<Package, Package> modelPackage2contextPackage = new HashMap<Package, Package>();
    private Map<Type, List<Type>> modelType2contextTypes = new HashMap<Type, List<Type>>();
    private Map<Type, List<Operation>> modelType2contextOperations = new HashMap<Type, List<Operation>>();
    private Map<Type, List<Property>> modelType2contextProperties = new HashMap<Type, List<Property>>();
    private Map<Operation, List<Constraint>> operation2postconditions = new HashMap<Operation, List<Constraint>>();
    private Map<Operation, List<Constraint>> operation2preconditions = new HashMap<Operation, List<Constraint>>();
    private Map<Property, List<Constraint>> property2invariants = new HashMap<Property, List<Constraint>>();
    private Map<Type, List<Constraint>> type2invariants = new HashMap<Type, List<Constraint>>();

    public CompleteOCLCSContainmentVisitor(@NonNull CS2PivotConversion context) {
        super(context);
    }

    protected void installOperationContainment(@NonNull Type modelType, @NonNull Type contextType) {
        List<Operation> newContextOperations = this.modelType2contextOperations.get(modelType);
        List oldContextOperations = contextType.getOwnedOperation();
        if (newContextOperations == null || newContextOperations.isEmpty()) {
            if (!oldContextOperations.isEmpty()) {
                oldContextOperations.clear();
            }
        } else {
            PivotUtil.refreshList((List)oldContextOperations, newContextOperations);
            for (Operation contextOperation : newContextOperations) {
                assert (contextOperation != null);
                PivotUtil.refreshList((List)contextOperation.getPrecondition(), this.operation2preconditions.get(contextOperation));
                PivotUtil.refreshList((List)contextOperation.getPostcondition(), this.operation2postconditions.get(contextOperation));
            }
        }
    }

    protected void installPackageContainment(@NonNull Root contextRoot) {
        HashMap<Package, HashSet<Package>> nestedContextPackageMaps = new HashMap<Package, HashSet<Package>>();
        HashSet<Package> nestedContextRoots = new HashSet<Package>();
        for (Package modelPackage : this.modelPackage2contextPackage.keySet()) {
            Package contextPackage = this.modelPackage2contextPackage.get(modelPackage);
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (parentModelPackage != null) {
                Package parentContextPackage = this.modelPackage2contextPackage.get(parentModelPackage);
                if (parentContextPackage == null) continue;
                HashSet<Package> nestedContextPackages = (HashSet<Package>)nestedContextPackageMaps.get(parentContextPackage);
                if (nestedContextPackages == null) {
                    nestedContextPackages = new HashSet<Package>();
                    nestedContextPackageMaps.put(parentContextPackage, nestedContextPackages);
                }
                nestedContextPackages.add(contextPackage);
                continue;
            }
            EObject modelPackageContainer = modelPackage.eContainer();
            if (!(modelPackageContainer instanceof Root)) continue;
            nestedContextRoots.add(contextPackage);
        }
        for (Package parentContextPackage : nestedContextPackageMaps.keySet()) {
            List nestedNestedPackages = parentContextPackage.getNestedPackage();
            Set nestedContextPackages = (Set)nestedContextPackageMaps.get(parentContextPackage);
            assert (nestedNestedPackages != null);
            assert (nestedContextPackages != null);
            PivotUtil.refreshSet((List)nestedNestedPackages, (Collection)nestedContextPackages);
        }
        List nestedPackages = contextRoot.getNestedPackage();
        assert (nestedPackages != null);
        PivotUtil.refreshSet((List)nestedPackages, nestedContextRoots);
    }

    protected void installPropertyContainment(@NonNull Type modelType, @NonNull Type contextType, @NonNull List<Constraint> allInvariants) {
        List<Property> contextProperties = this.modelType2contextProperties.get(modelType);
        if (contextProperties == null) {
            contextType.getOwnedAttribute().clear();
        } else {
            PivotUtil.refreshList((List)contextType.getOwnedAttribute(), contextProperties);
            for (Property contextProperty : contextProperties) {
                assert (contextProperty != null);
                List<Constraint> derivedInvariants = this.property2invariants.get(contextProperty);
                if (derivedInvariants == null) continue;
                allInvariants.addAll(derivedInvariants);
            }
        }
    }

    protected void installTypeContainment() {
        HashMap<Package, HashSet<Type>> nestedContextTypeMaps = new HashMap<Package, HashSet<Type>>();
        for (Type modelType : this.modelType2contextTypes.keySet()) {
            for (Type contextType : this.modelType2contextTypes.get(modelType)) {
                Package parentModelPackage = modelType.getPackage();
                Package parentContextPackage = this.modelPackage2contextPackage.get(parentModelPackage);
                HashSet<Type> ownedTypes = (HashSet<Type>)nestedContextTypeMaps.get(parentContextPackage);
                if (ownedTypes == null) {
                    ownedTypes = new HashSet<Type>();
                    nestedContextTypeMaps.put(parentContextPackage, ownedTypes);
                }
                ownedTypes.add(contextType);
                this.installOperationContainment(modelType, contextType);
                ArrayList<Constraint> allInvariants = new ArrayList<Constraint>();
                List<Constraint> typeInvariants = this.type2invariants.get(contextType);
                if (typeInvariants != null) {
                    allInvariants.addAll(typeInvariants);
                }
                this.installPropertyContainment(modelType, contextType, allInvariants);
                PivotUtil.refreshList((List)contextType.getOwnedInvariant(), allInvariants);
            }
        }
        for (Package parentContextPackage : nestedContextTypeMaps.keySet()) {
            Set ownedTypes = (Set)nestedContextTypeMaps.get(parentContextPackage);
            if (ownedTypes == null) continue;
            List parentOwnedTypes = parentContextPackage.getOwnedType();
            assert (parentOwnedTypes != null);
            PivotUtil.refreshSet((List)parentOwnedTypes, (Collection)ownedTypes);
        }
    }

    protected Package refreshContextPackage(@NonNull Package modelPackage, @Nullable PackageDeclarationCS csElement) {
        Package contextPackage;
        if (modelPackage.eIsProxy()) {
            return null;
        }
        Package contextPackage1 = this.modelPackage2contextPackage.get(modelPackage);
        if (contextPackage1 == null) {
            contextPackage = (Package)((CS2PivotConversion)this.context).refreshModelElement(Package.class, PivotPackage.Literals.PACKAGE, (ModelElementCS)csElement);
            String newName = modelPackage.getName();
            if (csElement != null) {
                EList newPath = csElement.getPathName().getPath();
                PathElementCS lastPathElement = (PathElementCS)newPath.get(newPath.size() - 1);
                Element asElement = lastPathElement.getPivot();
                newName = asElement instanceof Nameable && !asElement.eIsProxy() ? ((Nameable)asElement).getName() : ElementUtil.getTextName((ElementCS)lastPathElement);
            }
            ((CS2PivotConversion)this.context).refreshName((NamedElement)contextPackage, (String)DomainUtil.nonNullModel((Object)newName));
            ((CS2PivotConversion)this.context).refreshNsURI(contextPackage, modelPackage.getNsURI());
            this.modelPackage2contextPackage.put(modelPackage, contextPackage);
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (parentModelPackage != null) {
                this.refreshContextPackage(parentModelPackage, null);
            }
        } else {
            contextPackage = contextPackage1;
        }
        if (csElement != null) {
            ((CS2PivotConversion)this.context).refreshComments((Element)contextPackage, (ElementCS)csElement);
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)contextPackage);
        }
        return contextPackage;
    }

    protected Type refreshContextType(@NonNull Type modelClassifier, @Nullable ClassifierContextDeclCS csElement) {
        if (modelClassifier.eIsProxy()) {
            return null;
        }
        Type contextClassifier = (Type)((CS2PivotConversion)this.context).refreshModelElement(Class.class, PivotPackage.Literals.CLASS, (ModelElementCS)csElement);
        List<Type> contextClassifiers = this.modelType2contextTypes.get(modelClassifier);
        if (contextClassifiers == null) {
            contextClassifiers = new ArrayList<Type>();
            this.modelType2contextTypes.put(modelClassifier, contextClassifiers);
        }
        ((CS2PivotConversion)this.context).refreshName((NamedElement)contextClassifier, (String)DomainUtil.nonNullModel((Object)modelClassifier.getName()));
        contextClassifiers.add(contextClassifier);
        Package modelPackage = modelClassifier.getPackage();
        if (modelPackage != null) {
            EObject eContainer;
            PackageDeclarationCS csPackage = null;
            if (csElement != null && (eContainer = csElement.eContainer()) instanceof PackageDeclarationCS) {
                csPackage = (PackageDeclarationCS)eContainer;
            }
            Package contextPackage = contextClassifier.getPackage();
            if (csPackage != null || contextPackage == null) {
                this.refreshContextPackage(modelPackage, csPackage);
            } else {
                this.modelPackage2contextPackage.put(modelPackage, contextPackage);
            }
        }
        if (csElement != null) {
            ((CS2PivotConversion)this.context).refreshComments((Element)contextClassifier, (ElementCS)csElement);
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)contextClassifier);
        }
        return contextClassifier;
    }

    protected void registerOperation(@NonNull Type modelClassifier, @NonNull Operation pivotElement) {
        List<Operation> contextOperations = this.modelType2contextOperations.get(modelClassifier);
        if (contextOperations == null) {
            contextOperations = new ArrayList<Operation>();
            this.modelType2contextOperations.put(modelClassifier, contextOperations);
        }
        contextOperations.add(pivotElement);
    }

    protected void registerProperty(@NonNull Type modelClassifier, @NonNull Property pivotElement) {
        List<Property> contextProperties = this.modelType2contextProperties.get(modelClassifier);
        if (contextProperties == null) {
            contextProperties = new ArrayList<Property>();
            this.modelType2contextProperties.put(modelClassifier, contextProperties);
        }
        contextProperties.add(pivotElement);
    }

    @Override
    public Continuation<?> visitClassifierContextDeclCS(@NonNull ClassifierContextDeclCS csElement) {
        Type contextClassifier;
        Type modelClassifier = csElement.getClassifier();
        if (modelClassifier != null && (contextClassifier = this.refreshContextType(modelClassifier, csElement)) != null) {
            for (ConstraintCS csInvariant : csElement.getInvariants()) {
                Constraint constraint = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)csInvariant);
                if (constraint == null) continue;
                List constrainedElements = constraint.getConstrainedElement();
                constrainedElements.clear();
                constrainedElements.add(contextClassifier);
                List<Constraint> invariants = this.type2invariants.get(contextClassifier);
                if (invariants == null) {
                    invariants = new ArrayList<Constraint>();
                    this.type2invariants.put(contextClassifier, invariants);
                }
                invariants.add(constraint);
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitCompleteOCLDocumentCS(@NonNull CompleteOCLDocumentCS csElement) {
        for (IncludeCS csInclude : csElement.getOwnedInclude()) {
            csInclude.getNamespace();
        }
        Root contextRoot = this.refreshRoot(Root.class, PivotPackage.Literals.ROOT, csElement);
        ArrayList<Root> modelRoots = new ArrayList<Root>();
        for (Package modelPackage : this.modelPackage2contextPackage.keySet()) {
            Package parentModelPackage = modelPackage.getNestingPackage();
            if (parentModelPackage != null) continue;
            modelRoots.add((Root)modelPackage.eContainer());
        }
        this.installTypeContainment();
        this.installPackageContainment(contextRoot);
        return null;
    }

    @Override
    public Continuation<?> visitDefOperationCS(@NonNull DefOperationCS csElement) {
        Operation contextOperation = (Operation)this.refreshNamedElement(Operation.class, PivotPackage.Literals.OPERATION, (NamedElementCS)csElement);
        ClassifierContextDeclCS csClassifierContextDecl = csElement.getClassifierContextDecl();
        Type modelClassifier = csClassifierContextDecl.getClassifier();
        if (modelClassifier != null) {
            this.registerOperation(modelClassifier, contextOperation);
        }
        ((CS2PivotConversion)this.context).refreshPivotList(Parameter.class, contextOperation.getOwnedParameter(), csElement.getParameters());
        ExpressionInOCL pivotSpecification = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csElement.getSpecification());
        contextOperation.setBodyExpression((OpaqueExpression)pivotSpecification);
        return null;
    }

    @Override
    public Continuation<?> visitDefPropertyCS(@NonNull DefPropertyCS csElement) {
        Property contextProperty = (Property)this.refreshNamedElement(Property.class, PivotPackage.Literals.PROPERTY, (NamedElementCS)csElement);
        ClassifierContextDeclCS csClassifierContextDecl = csElement.getClassifierContextDecl();
        Type modelClassifier = csClassifierContextDecl.getClassifier();
        if (modelClassifier != null) {
            this.registerProperty(modelClassifier, contextProperty);
        }
        contextProperty.setIsDerived(true);
        contextProperty.setIsReadOnly(true);
        contextProperty.setIsTransient(true);
        contextProperty.setIsVolatile(true);
        contextProperty.setIsResolveProxies(false);
        ExpressionInOCL pivotSpecification = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csElement.getSpecification());
        contextProperty.setDefaultExpression((OpaqueExpression)pivotSpecification);
        return null;
    }

    public Continuation<?> visitImportCS(@NonNull ImportCS csElement) {
        super.visitImportCS(csElement);
        Namespace namespace = csElement.getNamespace();
        if (namespace != null && !namespace.eIsProxy()) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)namespace);
        }
        return null;
    }

    @Override
    public Continuation<?> visitIncludeCS(@NonNull IncludeCS csElement) {
        return null;
    }

    public Continuation<?> visitLibraryCS(@NonNull LibraryCS csElement) {
        Namespace pPackage = csElement.getPackage();
        if (pPackage != null && !pPackage.eIsProxy()) {
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, (Element)pPackage);
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperationContextDeclCS(@NonNull OperationContextDeclCS csElement) {
        List constrainedElements;
        EList<ParameterCS> csParameters = csElement.getParameters();
        assert (csParameters != null);
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.OPERATION, (ElementCS)csElement, (ScopeFilter)new OperationDeclScopeFilter(null, (List<ParameterCS>)csParameters));
        EList path = pathName.getPath();
        int pathSize = path.size();
        Element modelParent = pathSize >= 2 ? ((PathElementCS)path.get(pathSize - 2)).getElement() : null;
        Operation contextOperation = (Operation)((CS2PivotConversion)this.context).refreshModelElement(Operation.class, PivotPackage.Literals.OPERATION, (ModelElementCS)csElement);
        if (modelParent instanceof Type) {
            Type modelClassifier = (Type)modelParent;
            this.refreshContextType(modelClassifier, null);
            this.registerOperation(modelClassifier, contextOperation);
        }
        ((CS2PivotConversion)this.context).refreshPivotList(Parameter.class, contextOperation.getOwnedParameter(), csParameters);
        ((CS2PivotConversion)this.context).refreshComments((Element)contextOperation, (ElementCS)csElement);
        for (ConstraintCS csPrecondition : csElement.getPreconditions()) {
            Constraint precondition = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)csPrecondition);
            if (precondition == null) continue;
            constrainedElements = precondition.getConstrainedElement();
            constrainedElements.clear();
            constrainedElements.add(contextOperation);
            List<Constraint> preconditions = this.operation2preconditions.get(contextOperation);
            if (preconditions == null) {
                preconditions = new ArrayList<Constraint>();
                this.operation2preconditions.put(contextOperation, preconditions);
            }
            preconditions.add(precondition);
        }
        for (ConstraintCS csPostcondition : csElement.getPostconditions()) {
            Constraint postcondition = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)csPostcondition);
            if (postcondition == null) continue;
            constrainedElements = postcondition.getConstrainedElement();
            constrainedElements.clear();
            constrainedElements.add(contextOperation);
            List<Constraint> postconditions = this.operation2postconditions.get(contextOperation);
            if (postconditions == null) {
                postconditions = new ArrayList<Constraint>();
                this.operation2postconditions.put(contextOperation, postconditions);
            }
            postconditions.add(postcondition);
        }
        EList<ExpSpecificationCS> csBodies = csElement.getBodies();
        int iMax = csBodies.size();
        int i = 1;
        while (i < iMax) {
            SpecificationCS csBody = (SpecificationCS)csBodies.get(i);
            if (csBody != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csBody, "Multiple body expression ignored");
            }
            ++i;
        }
        ExpSpecificationCS csBody = iMax > 0 ? (ExpSpecificationCS)csBodies.get(0) : null;
        contextOperation.setBodyExpression((OpaqueExpression)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csBody));
        return null;
    }

    @Override
    public Continuation<?> visitPackageDeclarationCS(@NonNull PackageDeclarationCS csElement) {
        Package modelPackage = csElement.getPackage();
        if (modelPackage != null) {
            this.refreshContextPackage(modelPackage, csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitPropertyContextDeclCS(@NonNull PropertyContextDeclCS csElement) {
        Property modelProperty = csElement.getProperty();
        Property contextProperty = (Property)((CS2PivotConversion)this.context).refreshModelElement(Property.class, PivotPackage.Literals.PROPERTY, (ModelElementCS)csElement);
        if (modelProperty != null && !modelProperty.eIsProxy()) {
            ((CS2PivotConversion)this.context).refreshName((NamedElement)contextProperty, (String)DomainUtil.nonNullModel((Object)modelProperty.getName()));
            contextProperty.setType(modelProperty.getType());
            Type modelClassifier = modelProperty.getOwningType();
            if (modelClassifier != null) {
                this.refreshContextType(modelClassifier, null);
                this.registerProperty(modelClassifier, contextProperty);
            }
        }
        ((CS2PivotConversion)this.context).refreshComments((Element)contextProperty, (ElementCS)csElement);
        for (ConstraintCS csInvariant : csElement.getDerivedInvariants()) {
            Constraint invariant = (Constraint)PivotUtil.getPivot(Constraint.class, (Pivotable)csInvariant);
            if (invariant == null) continue;
            List constrainedElements = invariant.getConstrainedElement();
            constrainedElements.clear();
            constrainedElements.add(contextProperty);
            List<Constraint> invariants = this.property2invariants.get(contextProperty);
            if (invariants == null) {
                invariants = new ArrayList<Constraint>();
                this.property2invariants.put(contextProperty, invariants);
            }
            invariants.add(invariant);
        }
        EList<ExpSpecificationCS> csDefaults = csElement.getDefaultExpressions();
        int iMax = csDefaults.size();
        int i = 1;
        while (i < iMax) {
            SpecificationCS csDefault = (SpecificationCS)csDefaults.get(i);
            if (csDefault != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csDefault, "Multiple default expression ignored");
            }
            ++i;
        }
        ExpSpecificationCS csDefault = iMax > 0 ? (ExpSpecificationCS)csDefaults.get(0) : null;
        contextProperty.setDefaultExpression((OpaqueExpression)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csDefault));
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OperationDeclScopeFilter
    extends AbstractOperationFilter {
        @NonNull
        private final List<ParameterCS> csParameters;

        public OperationDeclScopeFilter(@NonNull Type sourceType, List<ParameterCS> csParameters) {
            super(sourceType);
            this.csParameters = csParameters;
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull Object object) {
            if (object instanceof Iteration) {
                return false;
            }
            if (object instanceof Operation) {
                Operation candidateOperation = (Operation)object;
                List candidateParameters = candidateOperation.getOwnedParameter();
                int iMax = this.csParameters.size();
                if (iMax != candidateParameters.size()) {
                    return false;
                }
                Map bindings = this.getOperationBindings(CompleteOCLCSContainmentVisitor.this.metaModelManager, candidateOperation);
                int i = 0;
                while (i < iMax) {
                    Parameter candidateParameter = (Parameter)candidateParameters.get(i);
                    if (candidateParameter != null) {
                        ParameterCS csParameter = this.csParameters.get(i);
                        if (csParameter == null) {
                            return false;
                        }
                        TypedRefCS csType = csParameter.getOwnedType();
                        Type pType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType);
                        if (pType == null) {
                            return false;
                        }
                        Type candidateType = PivotUtil.getType((TypedElement)candidateParameter);
                        pType = PivotUtil.getType((Type)pType);
                        if (candidateType == null || !CompleteOCLCSContainmentVisitor.this.metaModelManager.conformsTo(pType, candidateType, bindings)) {
                            return false;
                        }
                    }
                    ++i;
                }
                if (bindings != null) {
                    this.installBindings(environmentView, object, bindings);
                }
                return true;
            }
            return false;
        }
    }
}

