/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.internal.tool.command.builders;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceCreatedEventsFlaggingSiriusCommand;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.tools.internal.command.builders.PaneBasedSelectionWizardCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;

public class SequencePaneBasedSelectionWizardCommandBuilder
extends PaneBasedSelectionWizardCommandBuilder
implements SequenceToolCommandBuilder {
    protected EventEnd endBefore;
    private Point location;

    public SequencePaneBasedSelectionWizardCommandBuilder(PaneBasedSelectionWizardDescription tool, DSemanticDecorator containerView, Collection<EObject> selectedElements, EventEnd endBefore, Point location) {
        super(tool, containerView, selectedElements);
        this.endBefore = endBefore;
        this.location = location;
    }

    protected boolean evaluatePrecondition(IInterpreter interpreter, EObject semanticContainer, String precondition) {
        interpreter.setVariable("endBefore", (Object)this.endBefore);
        boolean result = super.evaluatePrecondition(interpreter, semanticContainer, precondition);
        interpreter.unSetVariable("endBefore");
        return result;
    }

    protected DCommand createEnclosingCommand() {
        Option parentDiagram = this.getDDiagram();
        Predicate viewpointElementPredicate = Predicates.or((Predicate[])new Predicate[]{Message.viewpointElementPredicate(), Execution.viewpointElementPredicate(), State.viewpointElementPredicate(), CombinedFragment.viewpointElementPredicate(), Operand.viewpointElementPredicate(), InteractionUse.viewpointElementPredicate()});
        SequenceCreatedEventsFlaggingSiriusCommand cmd = new SequenceCreatedEventsFlaggingSiriusCommand(this.editingDomain, this.getEnclosingCommandLabel(), (DDiagram)parentDiagram.get(), (Predicate<DDiagramElement>)viewpointElementPredicate);
        if (this.location != null) {
            cmd.setLostNodesLocation(this.location);
        }
        return cmd;
    }

    protected void addPreOperationTasks(DCommand command, final IInterpreter interpreter) {
        super.addPreOperationTasks(command, interpreter);
        command.getTasks().add(new AbstractCommandTask(){

            public String getLabel() {
                return "Add end before variable";
            }

            public void execute() {
                interpreter.setVariable("endBefore", (Object)SequencePaneBasedSelectionWizardCommandBuilder.this.endBefore);
            }
        });
    }

    protected void addPostOperationTasks(DCommand command, final IInterpreter interpreter) {
        super.addPostOperationTasks(command, interpreter);
        command.getTasks().add(new AbstractCommandTask(){

            public String getLabel() {
                return "Unset end before variable";
            }

            public void execute() {
                interpreter.unSetVariable("endBefore");
            }
        });
    }
}

