/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshGraphicalOrderingOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.RefreshSemanticOrderingsOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SynchronizeGraphicalOrderingOperation;

public class RefreshLayoutCommand
extends RecordingCommand {
    private Diagram diagram;
    private boolean refreshDiagram;

    public RefreshLayoutCommand(TransactionalEditingDomain domain, Diagram diagram, boolean refreshDiagram) {
        super(domain, "Refresh graphical layout");
        this.diagram = diagram;
        this.refreshDiagram = refreshDiagram;
    }

    protected void doExecute() {
        SequenceDiagram sequenceDiagram = (SequenceDiagram)ISequenceElementAccessor.getSequenceDiagram(this.diagram).get();
        SequenceDDiagram sequenceDDiagram = sequenceDiagram.getSequenceDDiagram();
        RefreshSemanticOrderingsOperation refreshSemanticOrderingOperation = new RefreshSemanticOrderingsOperation(sequenceDDiagram);
        refreshSemanticOrderingOperation.execute();
        RefreshGraphicalOrderingOperation refreshGraphicalOrderingOperation = new RefreshGraphicalOrderingOperation(sequenceDiagram);
        refreshGraphicalOrderingOperation.execute();
        if (this.refreshDiagram) {
            SynchronizeGraphicalOrderingOperation synchronizeGraphicalOrderingOperation = new SynchronizeGraphicalOrderingOperation(this.diagram, false);
            synchronizeGraphicalOrderingOperation.execute();
            refreshGraphicalOrderingOperation.execute();
        }
    }
}

