/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.swt.widgets.Display;

public class ViewUtils {
    public static View findFullLifelineCompartmentView(View lifelineView) {
        List<View> timelineCompartmentViews = ViewUtils.findSubViewsWithId(lifelineView, 8);
        if (timelineCompartmentViews.size() < 1) {
            throw new IllegalStateException("No timeline compartment found in the lifeline View");
        }
        return timelineCompartmentViews.get(0);
    }

    public static View findCompactTimelineCompartmentView(View lifelineView) {
        List<View> timelineCompartmentViews = ViewUtils.findSubViewsWithId(lifelineView, 23);
        if (timelineCompartmentViews.size() < 1) {
            throw new IllegalStateException("No timeline compartment found in the lifeline View");
        }
        return timelineCompartmentViews.get(0);
    }

    public static View findChildTimelineCompartmentView(View view) {
        List<View> timelineCompartmentViews = ViewUtils.findSubViewsWithId(view, 8);
        if (!timelineCompartmentViews.isEmpty()) {
            return timelineCompartmentViews.get(0);
        }
        timelineCompartmentViews = ViewUtils.findSubViewsWithId(view, 23);
        if (!timelineCompartmentViews.isEmpty()) {
            return timelineCompartmentViews.get(0);
        }
        throw new IllegalStateException("No timeline compartment found in the given View");
    }

    public static View findTimeRulerCompartmentView(View view) {
        List<View> timeRulerCompartmentViews = ViewUtils.findSubViewsWithId(view, 29);
        if (!timeRulerCompartmentViews.isEmpty()) {
            return timeRulerCompartmentViews.get(0);
        }
        timeRulerCompartmentViews = ViewUtils.findSubViewsWithId(view, 82);
        if (!timeRulerCompartmentViews.isEmpty()) {
            return timeRulerCompartmentViews.get(0);
        }
        timeRulerCompartmentViews = ViewUtils.findSubViewsWithId(view, 83);
        if (!timeRulerCompartmentViews.isEmpty()) {
            return timeRulerCompartmentViews.get(0);
        }
        throw new IllegalStateException("No timeruler compartment found in the View");
    }

    public static View findInteractionCompartmentView(View interactionView) {
        List<View> timelineCompartmentViews = ViewUtils.findSubViewsWithId(interactionView, 5);
        if (timelineCompartmentViews.isEmpty()) {
            throw new IllegalStateException("No interaction compartment found in the interaction View");
        }
        return timelineCompartmentViews.get(0);
    }

    public static View findStateDefinitionCompartmentView(View lifelineView) {
        List<View> timelineCompartmentViews = ViewUtils.findSubViewsWithId(lifelineView, 7);
        if (timelineCompartmentViews.isEmpty()) {
            throw new IllegalStateException("No state definition compartment found in the lifeline View");
        }
        return timelineCompartmentViews.get(0);
    }

    public static View findFirstChildViewWithId(View view, int visualId) {
        List<View> result = ViewUtils.findSubViewsWithId(view, visualId);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public static List<View> findSubViewsWithId(View view, int visualId) {
        ArrayList<View> views = new ArrayList<View>();
        ViewUtils.internalFindSubViewsWithId(view, visualId, views);
        return views;
    }

    private static List<View> internalFindSubViewsWithId(View view, int visualId, List<View> result) {
        EList children = view.getChildren();
        for (View child : children) {
            if (UMLVisualIDRegistry.getVisualID(child) == visualId) {
                result.add(child);
            }
            ViewUtils.internalFindSubViewsWithId(child, visualId, result);
        }
        return null;
    }

    public static View findSuperViewWithId(View view, int visualId) {
        View parent = view;
        while (parent != null) {
            View parentView;
            if (parent instanceof View && UMLVisualIDRegistry.getVisualID(parentView = parent) == visualId) {
                return parentView;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public static String getContainingDiagramType(View view) {
        if (view instanceof Diagram) {
            Diagram diagram = (Diagram)view;
            return diagram.getType();
        }
        EObject eContainer = view.eContainer();
        if (eContainer instanceof View) {
            View parentView = (View)eContainer;
            return ViewUtils.getContainingDiagramType(parentView);
        }
        return null;
    }

    public static ICommand getMoveViewCommand(final View parentView, final View viewToMove, final int targetIndex) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)parentView);
        return new AbstractTransactionalCommand(editingDomain, Messages.ViewUtils_MoveView, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int newIndex = targetIndex;
                EList children = parentView.getChildren();
                int size = children.size();
                int index = children.indexOf((Object)viewToMove);
                if (index < targetIndex) {
                    --newIndex;
                }
                if (newIndex < 0) {
                    newIndex = 0;
                }
                if (newIndex > size - 1) {
                    newIndex = size - 1;
                }
                ViewUtil.repositionChildAt((View)parentView, (View)viewToMove, (int)newIndex);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public static boolean isContained(View child, View parent) {
        View view = child;
        while (view != null) {
            if (view == parent) {
                return true;
            }
            EObject eContainer = view.eContainer();
            if (!(eContainer instanceof View)) break;
            view = (View)eContainer;
        }
        return false;
    }

    public static boolean isViewFor(View view, EClass ... eClasses) {
        EObject element = view.getElement();
        EClass[] eClassArray = eClasses;
        int n = eClasses.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (eClass.isInstance((Object)element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean containsViewFor(View parentView, EObject eObject) {
        if (parentView.getElement() == eObject) {
            return true;
        }
        EList children = parentView.getChildren();
        for (View child : children) {
            if (!ViewUtils.containsViewFor(child, eObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConnectorFor(View referenceView, EObject eObject) {
        View parentDiagramView1 = ViewUtils.findSuperViewWithId(referenceView, 1);
        Set existingViews = CrossReferencerUtil.getCrossReferencingViews((EObject)eObject, (String)"PapyrusUMLTimingDiagram");
        for (View existingView : existingViews) {
            View parentDiagramView2;
            if (!(existingView instanceof Connector) || parentDiagramView1 != (parentDiagramView2 = ViewUtils.findSuperViewWithId(existingView, 1))) continue;
            return true;
        }
        return false;
    }

    public static void selectInViewer(View view, EditPartViewer viewer) {
        EditPart editPart = (EditPart)viewer.getEditPartRegistry().get(view);
        if (editPart != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
    }

    public static void performEditRequest(View view, EditPartViewer viewer) {
        final EditPart editPart = (EditPart)viewer.getEditPartRegistry().get(view);
        if (editPart != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (editPart.isActive()) {
                        editPart.performRequest(new Request((Object)"direct edit"));
                        EditPartUtils.revealEditPart(editPart);
                    }
                }
            });
        }
    }
}

