/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.StateDefinitionEditPart;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;

public final class StateDefinitionUtils {
    private static final String LIFELINE_STATE_DEFINITIONS_KEY = "org.eclipse.papyrus.uml.diagram.timing.LifelineStateDefinitions";
    private static final String STATE_DEFINITION_VIEW_KEY = "org.eclipse.papyrus.uml.diagram.timing.StateDefinitionView";
    private static final String STATE_DEFINITION_VIEW_ID_KEY = "org.eclipse.papyrus.uml.diagram.timing.StateDefinitionViewID";
    private static final String STATE_DEFINITION_VIEW_NAME_KEY = "org.eclipse.papyrus.uml.diagram.timing.StateDefinitionViewName";

    private StateDefinitionUtils() {
    }

    public static boolean hasStateDefinitionEAnnotation(Lifeline lifeline) {
        EAnnotation eAnnotation = lifeline.getEAnnotation(LIFELINE_STATE_DEFINITIONS_KEY);
        if (eAnnotation == null) {
            return false;
        }
        return !eAnnotation.getDetails().isEmpty();
    }

    public static EAnnotation getOrCreateStateDefinitionsEAnnotation(Lifeline lifeline) {
        EAnnotation eAnnotation = lifeline.getEAnnotation(LIFELINE_STATE_DEFINITIONS_KEY);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(LIFELINE_STATE_DEFINITIONS_KEY);
            lifeline.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static EAnnotation getStateDefinitionsEAnnotation(Lifeline lifeline) {
        return lifeline.getEAnnotation(LIFELINE_STATE_DEFINITIONS_KEY);
    }

    public static String getStateDefinitionViewID(View stateDefinitionView) {
        EAnnotation eAnnotation = stateDefinitionView.getEAnnotation(STATE_DEFINITION_VIEW_KEY);
        if (eAnnotation != null) {
            return (String)eAnnotation.getDetails().get((Object)STATE_DEFINITION_VIEW_ID_KEY);
        }
        return null;
    }

    private static EAnnotation getOrCreateStateDefinitionViewAnnotation(View stateDefinitionView) {
        EAnnotation eAnnotation = stateDefinitionView.getEAnnotation(STATE_DEFINITION_VIEW_KEY);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(STATE_DEFINITION_VIEW_KEY);
            stateDefinitionView.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static void setStateDefinitionViewID(View stateDefinitionView, String id) {
        EAnnotation eAnnotation = StateDefinitionUtils.getOrCreateStateDefinitionViewAnnotation(stateDefinitionView);
        eAnnotation.getDetails().put((Object)STATE_DEFINITION_VIEW_ID_KEY, (Object)id);
    }

    private static void setStateDefinitionViewName(View stateDefinitionView, String name) {
        EAnnotation eAnnotation = StateDefinitionUtils.getOrCreateStateDefinitionViewAnnotation(stateDefinitionView);
        eAnnotation.getDetails().put((Object)STATE_DEFINITION_VIEW_NAME_KEY, (Object)name);
    }

    public static void setStateDefinitionName(View stateDefinitionView, String newName) {
        StateDefinitionUtils.checkStateDefinitionView(stateDefinitionView);
        String stateDefinitionViewID = StateDefinitionUtils.getStateDefinitionViewID(stateDefinitionView);
        if (stateDefinitionViewID == null) {
            stateDefinitionViewID = EcoreUtil.generateUUID();
            StateDefinitionUtils.setStateDefinitionViewID(stateDefinitionView, stateDefinitionViewID);
        }
        Lifeline lifeline = StateDefinitionUtils.getParentLifeline(stateDefinitionView);
        EAnnotation lifelineEAnnotation = StateDefinitionUtils.getOrCreateStateDefinitionsEAnnotation(lifeline);
        lifelineEAnnotation.getDetails().put((Object)stateDefinitionViewID, (Object)newName);
        StateDefinitionUtils.setStateDefinitionViewName(stateDefinitionView, newName);
    }

    public static void removeStateDefinitionEAnnotationFromLifeline(String id, Lifeline lifeline) {
        EAnnotation lifelineEAnnotation = StateDefinitionUtils.getStateDefinitionsEAnnotation(lifeline);
        if (lifelineEAnnotation != null) {
            lifelineEAnnotation.getDetails().removeKey((Object)id);
        }
    }

    public static String getStateDefinitionName(View stateDefinitionView) {
        StateDefinitionUtils.checkStateDefinitionView(stateDefinitionView);
        String stateDefinitionViewID = StateDefinitionUtils.getStateDefinitionViewID(stateDefinitionView);
        if (stateDefinitionViewID == null) {
            return null;
        }
        Lifeline lifeline = StateDefinitionUtils.getParentLifeline(stateDefinitionView);
        return StateDefinitionUtils.getStateDefinitionName(stateDefinitionViewID, lifeline);
    }

    public static String getStateDefinitionName(String stateDefinitionViewID, Lifeline lifeline) {
        if (stateDefinitionViewID == null || lifeline == null) {
            return null;
        }
        EAnnotation lifelineEAnnotation = StateDefinitionUtils.getStateDefinitionsEAnnotation(lifeline);
        if (lifelineEAnnotation == null) {
            return null;
        }
        return (String)lifelineEAnnotation.getDetails().get((Object)stateDefinitionViewID);
    }

    public static View getParentLifelineView(View view) {
        String id = Integer.toString(19);
        View parent = view;
        while (parent != null) {
            if (id.equals(parent.getType())) {
                return parent;
            }
            parent = (View)parent.eContainer();
        }
        throw new IllegalStateException("Parent Lifeline not found");
    }

    public static Lifeline getParentLifeline(View view) {
        View parentLifelineView = StateDefinitionUtils.getParentLifelineView(view);
        if (parentLifelineView != null) {
            return (Lifeline)parentLifelineView.getElement();
        }
        return null;
    }

    public static void initNewStateDefinitionName(View stateDefinitionView) {
        StateDefinitionUtils.checkStateDefinitionView(stateDefinitionView);
        View stateDefinitionsCompartment = ViewUtils.findSuperViewWithId(stateDefinitionView, 7);
        List<View> allStateDefinitionViews = ViewUtils.findSubViewsWithId(stateDefinitionsCompartment, 9);
        HashSet<String> existingNames = new HashSet<String>();
        for (View aStateDefinitionView : allStateDefinitionViews) {
            existingNames.add(StateDefinitionUtils.getStateDefinitionName(aStateDefinitionView));
        }
        StateDefinitionUtils.setStateDefinitionName(stateDefinitionView, StateDefinitionUtils.findNewStateName(existingNames));
    }

    private static String findNewStateName(Set<String> existingNames) {
        String newName = "";
        String prefix = Messages.StateDefinitionUtils_State;
        int suffix = 1;
        while (existingNames.contains(newName = String.valueOf(prefix) + suffix)) {
            ++suffix;
        }
        return newName;
    }

    public static View getStateDefinitionViewWithId(String id, View lifelineView) {
        StateDefinitionUtils.checkLifelineView(lifelineView);
        List<View> stateDefinitionViews = ViewUtils.findSubViewsWithId(lifelineView, 9);
        for (View stateDefinitionView : stateDefinitionViews) {
            if (!id.equals(StateDefinitionUtils.getStateDefinitionViewID(stateDefinitionView))) continue;
            return stateDefinitionView;
        }
        return null;
    }

    public static View getStateDefinitionViewWithName(String name, View lifelineView) {
        StateDefinitionUtils.checkLifelineView(lifelineView);
        List<View> stateDefinitionViews = ViewUtils.findSubViewsWithId(lifelineView, 9);
        for (View stateDefinitionView : stateDefinitionViews) {
            if (!name.equals(StateDefinitionUtils.getStateDefinitionName(stateDefinitionView))) continue;
            return stateDefinitionView;
        }
        return null;
    }

    public static List<String> getStateDefinitionIds(Lifeline lifeline) {
        EAnnotation eAnnotation = StateDefinitionUtils.getStateDefinitionsEAnnotation(lifeline);
        if (eAnnotation != null) {
            EMap details = eAnnotation.getDetails();
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry entry : details) {
                result.add((String)entry.getKey());
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static void checkStateDefinitionView(View stateDefinitionView) {
        if (!Integer.toString(9).equals(stateDefinitionView.getType())) {
            throw new IllegalArgumentException("The parameter must be a StateDefinition View (id = 9). The id was " + stateDefinitionView.getType());
        }
    }

    private static void checkLifelineView(View lifelineView) {
        if (!Integer.toString(19).equals(lifelineView.getType())) {
            throw new IllegalArgumentException("The parameter must be a Lifeline View (id = 19). The id was " + lifelineView.getType());
        }
    }

    public static StateDefinitionEditPart findStateDefinitionClosestToOrdinate(FullLifelineEditPartCN lifelineEditPart, int ordinate) {
        List<? extends EditPart> editParts = EditPartUtils.findChildEditPartsWithId((EditPart)lifelineEditPart, 9);
        return (StateDefinitionEditPart)EditPartUtils.findEditPartClosestToOrdinate(ordinate, editParts);
    }

    public static void updateStateDefinitionNamesForCompactLifeline(Lifeline lifeline) {
        String name;
        EList coveredBys = lifeline.getCoveredBys();
        LinkedHashMap<String, String> nameIdMap = new LinkedHashMap<String, String>();
        for (InteractionFragment interactionFragment : coveredBys) {
            if (!(interactionFragment instanceof StateInvariant)) continue;
            StateInvariant stateInvariant = (StateInvariant)interactionFragment;
            name = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
            nameIdMap.put(name, EcoreUtil.generateUUID());
        }
        EAnnotation stateDefinitionsEAnnotation = StateDefinitionUtils.getOrCreateStateDefinitionsEAnnotation(lifeline);
        stateDefinitionsEAnnotation.getDetails().clear();
        for (Map.Entry entry : nameIdMap.entrySet()) {
            name = (String)entry.getKey();
            String id = (String)entry.getValue();
            stateDefinitionsEAnnotation.getDetails().put((Object)id, (Object)name);
        }
        for (InteractionFragment interactionFragment : coveredBys) {
            if (!(interactionFragment instanceof StateInvariant)) continue;
            StateInvariant stateInvariant = (StateInvariant)interactionFragment;
            String name2 = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
            String id = (String)nameIdMap.get(name2);
            StateInvariantUtils.setStateInvariantId(stateInvariant, id);
        }
    }
}

