/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeRulerUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.uml2.uml.Interaction;

public class CustomInteractionCompartmentCreationEditPolicy
extends PapyrusCreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        ICommandProxy superCommand = (ICommandProxy)super.getCreateCommand(request);
        List viewDescriptors = request.getViewDescriptors();
        if (request instanceof CreateViewAndElementRequest && viewDescriptors.size() == 1) {
            String semanticHint = ((CreateViewRequest.ViewDescriptor)viewDescriptors.get(0)).getSemanticHint();
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)this.getHost().getModel());
            if (Integer.toString(20).equals(semanticHint)) {
                View interactionView = (View)this.getHost().getParent().getModel();
                Interaction interaction = (Interaction)interactionView.getElement();
                CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomInteractionCompartmentCreationEditPolicy_CreateCompactLifeline);
                InteractionEditPartTN interactionEditPart = this.getInteractionEditPart();
                compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)interactionEditPart));
                compoundCommand.add(CustomInteractionCompartmentCreationEditPolicy.createCompactStateInvariantCommand((Command)superCommand, interaction));
                compoundCommand.add((Command)new ICommandProxy(TimeRulerUtils.getCreateFreeTimeRulerCommand((Command)superCommand, editingDomain, false)));
                compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)interactionEditPart));
                return compoundCommand;
            }
            if (Integer.toString(19).equals(semanticHint)) {
                CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomInteractionCompartmentCreationEditPolicy_CreateFullLifeline);
                InteractionEditPartTN interactionEditPart = this.getInteractionEditPart();
                compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)interactionEditPart));
                compoundCommand.add((Command)superCommand);
                compoundCommand.add((Command)new ICommandProxy(TimeRulerUtils.getCreateFreeTimeRulerCommand((Command)superCommand, editingDomain, false)));
                compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)interactionEditPart));
                return compoundCommand;
            }
        }
        return superCommand;
    }

    private static Command createCompactStateInvariantCommand(Command superCommand, Interaction interaction) {
        CompoundCommand compoundCommand = new CompoundCommand(Messages.CustomCompactLifelifeCompactStateInvariantCreationEditPolicy_CreateStateInvariant);
        compoundCommand.add(superCommand);
        final CommandResult superCommandResult = ((ICommandProxy)superCommand).getICommand().getCommandResult();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)interaction);
        if (editingDomain == null) {
            throw new IllegalStateException("no editing domain");
        }
        AbstractTransactionalCommand initStateDefinitionCommand = new AbstractTransactionalCommand(editingDomain, Messages.CustomCompactLifelifeCompactStateInvariantCreationEditPolicy_InitializeStateInvariant, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)superCommandResult.getReturnValue();
                View compactLifelineView = (View)viewDescriptor.getAdapter(View.class);
                View compactLifelineCompartmentView = ViewUtils.findCompactTimelineCompartmentView(compactLifelineView);
                StateInvariantUtils.createCompactStateInvariant(compactLifelineCompartmentView, -1, -1, -1);
                return CommandResult.newOKCommandResult();
            }
        };
        compoundCommand.add((Command)new ICommandProxy((ICommand)initStateDefinitionCommand));
        return compoundCommand;
    }

    protected InteractionEditPartTN getInteractionEditPart() {
        return (InteractionEditPartTN)EditPartUtils.findParentEditPartWithId(this.getHost(), 2);
    }

    protected CompactLifelineCompartmentEditPartCN getCompactLifelineCompartmentEditPart() {
        return (CompactLifelineCompartmentEditPartCN)EditPartUtils.findFirstChildEditPartWithId(this.getHost(), 23);
    }
}

