/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.yakindu.base.base.NamedElement;
import org.yakindu.sct.model.sgraph.Entry;
import org.yakindu.sct.model.sgraph.Exit;
import org.yakindu.sct.model.sgraph.ReactionProperty;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.Transition;
import org.yakindu.sct.model.stext.stext.EntryPointSpec;
import org.yakindu.sct.model.stext.stext.ExitPointSpec;

public final class STextValidationModelUtils {
    private STextValidationModelUtils() {
    }

    public static List<Transition>[] getEntrySpecSortedTransitions(List<Transition> elements) {
        ArrayList[] transitions = new ArrayList[]{new ArrayList(), new ArrayList()};
        for (Transition transition : elements) {
            boolean hasEntrySpec = false;
            for (ReactionProperty property : transition.getProperties()) {
                if (!(property instanceof EntryPointSpec)) continue;
                transitions[1].add(transition);
                hasEntrySpec = true;
                break;
            }
            if (hasEntrySpec) continue;
            transitions[0].add(transition);
        }
        return transitions;
    }

    public static List<Transition>[] getExitSpecSortedTransitions(List<Transition> elements) {
        ArrayList[] transitions = new ArrayList[]{new ArrayList(), new ArrayList()};
        for (Transition transition : elements) {
            boolean hasExitSpec = false;
            for (ReactionProperty property : transition.getProperties()) {
                if (!(property instanceof ExitPointSpec)) continue;
                transitions[1].add(transition);
                hasExitSpec = true;
                break;
            }
            if (hasExitSpec) continue;
            transitions[0].add(transition);
        }
        return transitions;
    }

    public static Map<Region, List<Entry>> getRegionsWithoutDefaultEntry(List<Region> elements) {
        HashMap<Region, List<Entry>> regions = new HashMap<Region, List<Entry>>();
        for (Region region : elements) {
            boolean hasDefaultEntry = false;
            List<Entry> entries = STextValidationModelUtils.getEntries((List<EObject>)region.eContents());
            for (Entry entry : entries) {
                if (!STextValidationModelUtils.isDefault((NamedElement)entry)) continue;
                hasDefaultEntry = true;
                break;
            }
            if (hasDefaultEntry) continue;
            regions.put(region, entries);
        }
        return regions;
    }

    public static Map<Region, List<Exit>> getRegionsWithoutDefaultExit(List<Region> elements) {
        HashMap<Region, List<Exit>> regions = new HashMap<Region, List<Exit>>();
        for (Region region : elements) {
            boolean hasDefaultExit = false;
            List<Exit> exits = STextValidationModelUtils.getExits((List<EObject>)region.eContents());
            if (!exits.isEmpty()) {
                for (Exit exit : exits) {
                    if (!STextValidationModelUtils.isDefault((NamedElement)exit)) continue;
                    hasDefaultExit = true;
                    break;
                }
            } else {
                hasDefaultExit = true;
            }
            if (hasDefaultExit) continue;
            regions.put(region, exits);
        }
        return regions;
    }

    public static boolean isDefault(NamedElement element) {
        return element.getName() == null || element.getName() != null && (element.getName().isEmpty() || element.getName().equalsIgnoreCase("default"));
    }

    public static boolean isNamedExitTransition(Transition transition, String name) {
        boolean isNamedExitTransition = false;
        Iterator propertyIt = transition.getProperties().iterator();
        while (propertyIt.hasNext() && !isNamedExitTransition) {
            ReactionProperty property = (ReactionProperty)propertyIt.next();
            if (!(property instanceof ExitPointSpec)) continue;
            isNamedExitTransition = name.equals(((ExitPointSpec)property).getExitpoint());
        }
        return isNamedExitTransition;
    }

    public static boolean isDefaultExitTransition(Transition transition) {
        boolean isDefault = false;
        List<ExitPointSpec> exits = STextValidationModelUtils.getExitPointSpecs((List<ReactionProperty>)transition.getProperties());
        if (!exits.isEmpty()) {
            for (ExitPointSpec exit : exits) {
                if (!exit.getExitpoint().equalsIgnoreCase("default")) continue;
                isDefault = true;
            }
        } else {
            isDefault = true;
        }
        return isDefault;
    }

    public static List<ExitPointSpec> getExitPointSpecs(List<ReactionProperty> elements) {
        ArrayList<ExitPointSpec> exits = new ArrayList<ExitPointSpec>();
        for (ReactionProperty element : elements) {
            if (!(element instanceof ExitPointSpec)) continue;
            exits.add((ExitPointSpec)element);
        }
        return exits;
    }

    public static List<Entry> getEntries(List<EObject> elements) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (EObject element : elements) {
            if (!(element instanceof Entry)) continue;
            entries.add((Entry)element);
        }
        return entries;
    }

    public static List<Exit> getExits(List<EObject> elements) {
        ArrayList<Exit> exits = new ArrayList<Exit>();
        for (EObject element : elements) {
            if (!(element instanceof Exit)) continue;
            exits.add((Exit)element);
        }
        return exits;
    }
}

