/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import de.itemis.xtext.utils.jface.viewers.ContextElementAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ComposedChecks;
import org.yakindu.base.base.NamedElement;
import org.yakindu.base.expressions.expressions.AssignmentExpression;
import org.yakindu.base.expressions.expressions.ElementReferenceExpression;
import org.yakindu.base.expressions.expressions.Expression;
import org.yakindu.base.expressions.expressions.ExpressionsPackage;
import org.yakindu.base.expressions.expressions.FeatureCall;
import org.yakindu.base.expressions.validation.ExpressionsJavaValidator;
import org.yakindu.base.types.Event;
import org.yakindu.base.types.Feature;
import org.yakindu.base.types.ITypeSystem;
import org.yakindu.base.types.InferenceResult;
import org.yakindu.base.types.Operation;
import org.yakindu.base.types.Property;
import org.yakindu.base.types.TypesPackage;
import org.yakindu.sct.model.sgraph.Choice;
import org.yakindu.sct.model.sgraph.Declaration;
import org.yakindu.sct.model.sgraph.Entry;
import org.yakindu.sct.model.sgraph.Exit;
import org.yakindu.sct.model.sgraph.ReactionProperty;
import org.yakindu.sct.model.sgraph.Region;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.model.sgraph.Scope;
import org.yakindu.sct.model.sgraph.ScopedElement;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Synchronization;
import org.yakindu.sct.model.sgraph.Transition;
import org.yakindu.sct.model.sgraph.Trigger;
import org.yakindu.sct.model.sgraph.Variable;
import org.yakindu.sct.model.sgraph.Vertex;
import org.yakindu.sct.model.sgraph.resource.AbstractSCTResource;
import org.yakindu.sct.model.sgraph.validation.SCTResourceValidator;
import org.yakindu.sct.model.sgraph.validation.SGraphJavaValidator;
import org.yakindu.sct.model.stext.services.STextGrammarAccess;
import org.yakindu.sct.model.stext.stext.DefaultTrigger;
import org.yakindu.sct.model.stext.stext.Direction;
import org.yakindu.sct.model.stext.stext.EntryEvent;
import org.yakindu.sct.model.stext.stext.EntryPointSpec;
import org.yakindu.sct.model.stext.stext.EventDefinition;
import org.yakindu.sct.model.stext.stext.EventRaisingExpression;
import org.yakindu.sct.model.stext.stext.EventSpec;
import org.yakindu.sct.model.stext.stext.ExitEvent;
import org.yakindu.sct.model.stext.stext.ExitPointSpec;
import org.yakindu.sct.model.stext.stext.Guard;
import org.yakindu.sct.model.stext.stext.Import;
import org.yakindu.sct.model.stext.stext.InterfaceScope;
import org.yakindu.sct.model.stext.stext.InternalScope;
import org.yakindu.sct.model.stext.stext.LocalReaction;
import org.yakindu.sct.model.stext.stext.ReactionEffect;
import org.yakindu.sct.model.stext.stext.ReactionTrigger;
import org.yakindu.sct.model.stext.stext.StextPackage;
import org.yakindu.sct.model.stext.stext.TimeEventSpec;
import org.yakindu.sct.model.stext.stext.VariableDefinition;
import org.yakindu.sct.model.stext.types.ISTextTypeInferrer;
import org.yakindu.sct.model.stext.validation.AbstractSTextJavaValidator;
import org.yakindu.sct.model.stext.validation.STextValidationMessages;
import org.yakindu.sct.model.stext.validation.STextValidationModelUtils;

@ComposedChecks(validators={SGraphJavaValidator.class, SCTResourceValidator.class, ExpressionsJavaValidator.class})
public class STextJavaValidator
extends AbstractSTextJavaValidator
implements STextValidationMessages {
    @Inject
    private ISTextTypeInferrer typeInferrer;
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private STextGrammarAccess grammarAccess;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    @Named(value="languageName")
    private String languageName;
    @Inject
    private IContainer.Manager containerManager;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    @Check(value=CheckType.FAST)
    public void transitionsWithNoTrigger(Transition trans) {
        State state;
        if (trans.getSource() instanceof Entry || trans.getSource() instanceof Choice || trans.getSource() instanceof Synchronization) {
            return;
        }
        if (trans.getSource() instanceof State && (state = (State)trans.getSource()).isComposite()) {
            for (Region r : state.getRegions()) {
                for (Vertex v : r.getVertices()) {
                    if (!(v instanceof Exit)) continue;
                    return;
                }
            }
        }
        if (!STextValidationModelUtils.getExitPointSpecs((List<ReactionProperty>)trans.getProperties()).isEmpty()) {
            return;
        }
        if (trans.getTrigger() == null) {
            this.warning("Missing trigger. Transisition is never taken. Use 'oncycle' or 'always' instead", (EObject)trans, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnusedEntry(Entry entry) {
        if (entry.getParentRegion().getComposite() instanceof State && entry.getIncomingTransitions().isEmpty()) {
            State state = (State)entry.getParentRegion().getComposite();
            if (!STextValidationModelUtils.isDefault((NamedElement)entry)) {
                boolean hasIncomingTransition = false;
                Iterator transitionIt = state.getIncomingTransitions().iterator();
                while (transitionIt.hasNext() && !hasIncomingTransition) {
                    Iterator propertyIt = ((Transition)transitionIt.next()).getProperties().iterator();
                    while (propertyIt.hasNext() && !hasIncomingTransition) {
                        ReactionProperty property = (ReactionProperty)propertyIt.next();
                        if (!(property instanceof EntryPointSpec)) continue;
                        hasIncomingTransition = entry.getName().equals(((EntryPointSpec)property).getEntrypoint());
                    }
                }
                if (!hasIncomingTransition) {
                    this.warning("The named entry is not used by incoming transitions.", (EObject)entry, null, -1);
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkLeftHandAssignment(AssignmentExpression expression) {
        Expression varRef = expression.getVarRef();
        if (varRef instanceof FeatureCall) {
            EObject referencedObject = ((FeatureCall)varRef).getFeature();
            if (!(referencedObject instanceof Variable) && !(referencedObject instanceof Property)) {
                this.error("The left-hand side of an assignment must be a variable", (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF);
            }
        } else if (varRef instanceof ElementReferenceExpression) {
            EObject referencedObject = ((ElementReferenceExpression)varRef).getReference();
            if (!(referencedObject instanceof Variable) && !(referencedObject instanceof Property)) {
                this.error("The left-hand side of an assignment must be a variable", (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF);
            }
        } else {
            this.error("The left-hand side of an assignment must be a variable", (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAssignmentToFinalVariable(AssignmentExpression exp) {
        Expression varRef = exp.getVarRef();
        EObject referencedObject = null;
        if (varRef instanceof FeatureCall) {
            referencedObject = ((FeatureCall)varRef).getFeature();
        } else if (varRef instanceof ElementReferenceExpression) {
            referencedObject = ((ElementReferenceExpression)varRef).getReference();
        }
        if (referencedObject instanceof VariableDefinition && ((VariableDefinition)referencedObject).isConst()) {
            this.error("Assignment constant not allowed", (EStructuralFeature)ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__VAR_REF);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValueDefinitionExpression(VariableDefinition definition) {
        if (!definition.isConst()) {
            return;
        }
        Expression initialValue = definition.getInitialValue();
        ArrayList toCheck = Lists.newArrayList((Object[])new Expression[]{initialValue});
        TreeIterator eAllContents = initialValue.eAllContents();
        while (eAllContents.hasNext()) {
            EObject next = (EObject)eAllContents.next();
            if (!(next instanceof Expression)) continue;
            toCheck.add((Expression)next);
        }
        for (Expression expression : toCheck) {
            EObject referencedObject = null;
            if (expression instanceof FeatureCall) {
                referencedObject = ((FeatureCall)expression).getFeature();
            } else if (expression instanceof ElementReferenceExpression) {
                referencedObject = ((ElementReferenceExpression)expression).getReference();
            }
            if (!(referencedObject instanceof VariableDefinition) || ((VariableDefinition)referencedObject).isConst()) continue;
            this.error("Cannot reference a variable in a constant initialization", (EStructuralFeature)StextPackage.Literals.VARIABLE_DEFINITION__INITIAL_VALUE);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValueReferenedBeforeDefined(Scope scope) {
        EList declarations = scope.getDeclarations();
        HashSet defined = Sets.newHashSet();
        for (Declaration declaration : declarations) {
            if (!(declaration instanceof VariableDefinition)) continue;
            VariableDefinition definition = (VariableDefinition)declaration;
            if (!definition.isConst()) {
                return;
            }
            Expression initialValue = definition.getInitialValue();
            ArrayList toCheck = Lists.newArrayList((Object[])new Expression[]{initialValue});
            TreeIterator eAllContents = initialValue.eAllContents();
            while (eAllContents.hasNext()) {
                EObject next = (EObject)eAllContents.next();
                if (!(next instanceof Expression)) continue;
                toCheck.add((Expression)next);
            }
            for (Expression expression : toCheck) {
                EObject referencedObject = null;
                if (expression instanceof FeatureCall) {
                    referencedObject = ((FeatureCall)expression).getFeature();
                } else if (expression instanceof ElementReferenceExpression) {
                    referencedObject = ((ElementReferenceExpression)expression).getReference();
                }
                if (!(referencedObject instanceof VariableDefinition) || defined.contains(this.nameProvider.getFullyQualifiedName(referencedObject))) continue;
                this.error("Cannot reference a constant from different scope or before it is defined", (EObject)definition, (EStructuralFeature)StextPackage.Literals.VARIABLE_DEFINITION__INITIAL_VALUE);
            }
            defined.add(this.nameProvider.getFullyQualifiedName((EObject)definition));
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnusedExit(Exit exit) {
        if (exit.getParentRegion().getComposite() instanceof State && exit.getOutgoingTransitions().isEmpty()) {
            State state = (State)exit.getParentRegion().getComposite();
            if (!STextValidationModelUtils.isDefault((NamedElement)exit)) {
                boolean hasOutgoingTransition = false;
                Iterator transitionIt = state.getOutgoingTransitions().iterator();
                while (transitionIt.hasNext() && !hasOutgoingTransition) {
                    Transition transition = (Transition)transitionIt.next();
                    boolean bl = hasOutgoingTransition = STextValidationModelUtils.isDefaultExitTransition(transition) ? true : STextValidationModelUtils.isNamedExitTransition(transition, exit.getName());
                }
                if (!hasOutgoingTransition) {
                    this.error("The named exit is not used by outgoing transitions.", (EObject)exit, null, -1);
                }
            } else {
                boolean hasOutgoingTransition = false;
                Iterator transitionIt = state.getOutgoingTransitions().iterator();
                while (transitionIt.hasNext() && !hasOutgoingTransition) {
                    hasOutgoingTransition = STextValidationModelUtils.isDefaultExitTransition((Transition)transitionIt.next());
                }
                if (!hasOutgoingTransition) {
                    this.error("The parent composite state has no 'default' exit transition.", (EObject)exit, null, -1);
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkTransitionPropertySpec(Transition transition) {
        for (ReactionProperty property : transition.getProperties()) {
            if (property instanceof EntryPointSpec) {
                State state;
                if (!(transition.getTarget() instanceof State) || (state = (State)transition.getTarget()).isComposite()) continue;
                this.warning("Target state isn't composite", (EObject)transition, null, -1);
                continue;
            }
            if (!(property instanceof ExitPointSpec)) continue;
            ExitPointSpec exitPointSpec = (ExitPointSpec)property;
            if (!(transition.getSource() instanceof State)) continue;
            State state = (State)transition.getSource();
            if (!state.isComposite()) {
                this.warning("Source state isn't composite", (EObject)transition, null, -1);
                continue;
            }
            for (Transition t : state.getOutgoingTransitions()) {
                if (transition == t || !STextValidationModelUtils.isNamedExitTransition(t, exitPointSpec.getExitpoint())) continue;
                this.warning("ExitPointSpec can't be used on transition siblings.", (EObject)transition, null, -1);
            }
            boolean hasExit = false;
            Iterator regionIter = state.getRegions().iterator();
            while (regionIter.hasNext() && !hasExit) {
                Iterator<Exit> exitIter = STextValidationModelUtils.getExits((List<EObject>)((Region)regionIter.next()).eContents()).iterator();
                while (exitIter.hasNext() && !hasExit) {
                    Exit exit = exitIter.next();
                    hasExit = exitPointSpec.getExitpoint().equals(exit.getName());
                }
            }
            if (hasExit) continue;
            this.error("Source State needs at least one region with the named exit point", (EObject)transition, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkUnboundEntryPoints(State state) {
        if (state.isComposite()) {
            List<Transition>[] transitions = STextValidationModelUtils.getEntrySpecSortedTransitions((List<Transition>)state.getIncomingTransitions());
            Map<Region, List<Entry>> regions = null;
            if (!transitions[0].isEmpty() && !(regions = STextValidationModelUtils.getRegionsWithoutDefaultEntry((List<Region>)state.getRegions())).isEmpty()) {
                for (Transition transition : transitions[0]) {
                    this.error("Target state has regions without 'default' entries.", (EObject)transition, null, -1);
                }
                for (Region region : regions.keySet()) {
                    this.error("Region must have a 'default' entry.", (EObject)region, null, -1);
                }
            }
            if (!transitions[1].isEmpty()) {
                if (regions == null) {
                    regions = STextValidationModelUtils.getRegionsWithoutDefaultEntry((List<Region>)state.getRegions());
                }
                for (Transition transition : transitions[1]) {
                    boolean hasTargetEntry = true;
                    for (ReactionProperty property : transition.getProperties()) {
                        if (!(property instanceof EntryPointSpec)) continue;
                        EntryPointSpec spec = (EntryPointSpec)property;
                        String specName = "'" + spec.getEntrypoint() + "'";
                        for (Region region : regions.keySet()) {
                            boolean hasEntry = false;
                            for (Entry entry : regions.get(region)) {
                                if (!entry.getName().equals(spec.getEntrypoint())) continue;
                                hasEntry = true;
                                break;
                            }
                            if (hasEntry) continue;
                            this.error("Region should have a named entry to support transitions entry specification: " + specName, (EObject)region, null, -1);
                            hasTargetEntry = false;
                        }
                        if (hasTargetEntry) continue;
                        this.error("Target state has regions without named entries: " + specName, (EObject)transition, null, -1);
                    }
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkVariableDefinition(VariableDefinition definition) {
        try {
            InferenceResult result = this.typeInferrer.inferType(definition);
            if (result.getType() != null && this.typeSystem.isVoidType(result.getType())) {
                this.error("'void' is an invalid type for variables", null);
            } else {
                this.report(result, null);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Check(value=CheckType.FAST)
    public void checkOperationArguments_FeatureCall(FeatureCall call) {
        if (call.getFeature() instanceof Operation) {
            Operation operation = (Operation)call.getFeature();
            EList parameters = operation.getParameters();
            EList args = call.getArgs();
            if (parameters.size() != args.size()) {
                this.error("Wrong number of arguments, expected " + parameters, null);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkOperationArguments_TypedElementReferenceExpression(ElementReferenceExpression call) {
        if (call.getReference() instanceof Operation) {
            Operation operation = (Operation)call.getReference();
            EList parameters = operation.getParameters();
            EList args = call.getArgs();
            if (parameters.size() != args.size()) {
                this.error("Wrong number of arguments, expected " + parameters, null);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAssignmentExpression(AssignmentExpression exp) {
        final String name = this.getVariableName(exp);
        List contents = EcoreUtil2.eAllOfType((EObject)exp, AssignmentExpression.class);
        contents.remove(exp);
        Iterable filter = Iterables.filter((Iterable)contents, (Predicate)new Predicate<AssignmentExpression>(){

            public boolean apply(AssignmentExpression ex) {
                String variableName = STextJavaValidator.this.getVariableName(ex);
                return variableName.equals(name);
            }
        });
        if (Iterables.size((Iterable)filter) > 0) {
            this.error("No nested assignment of the same variable allowed (different behavior in various programming languages)", null);
        }
    }

    private String getVariableName(AssignmentExpression exp) {
        Expression varRef = exp.getVarRef();
        if (varRef instanceof ElementReferenceExpression && ((ElementReferenceExpression)varRef).getReference() instanceof Property) {
            Property reference = (Property)((ElementReferenceExpression)varRef).getReference();
            return reference.getName();
        }
        if (varRef instanceof FeatureCall && ((FeatureCall)varRef).getFeature() instanceof Property) {
            Property reference = (Property)((FeatureCall)varRef).getFeature();
            return reference.getName();
        }
        return null;
    }

    @Check(value=CheckType.FAST)
    public void checkFeatureCall(FeatureCall call) {
        if (call.eContainer() instanceof FeatureCall) {
            return;
        }
        if (call.getFeature() instanceof Scope) {
            this.error("A variable, event or operation is required", (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, "FEATURE_CALL_TO_SCOPE", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkFeatureCall(ElementReferenceExpression call) {
        if (call.eContainer() instanceof FeatureCall) {
            return;
        }
        if (call.getReference() instanceof Scope) {
            this.error("A variable, event or operation is required", (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, "FEATURE_CALL_TO_SCOPE", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkGuard(Guard guard) {
        try {
            InferenceResult result = this.typeInferrer.inferType(guard.getExpression());
            if (result.getType() == null || !this.typeSystem.isBooleanType(result.getType())) {
                this.error("The evaluation result of a guard expression must be of type boolean", (EStructuralFeature)StextPackage.Literals.GUARD__EXPRESSION);
            }
            this.report(result, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Check(value=CheckType.FAST)
    public void checkTimeEventSpecValueExpression(TimeEventSpec spec) {
        try {
            InferenceResult result = this.typeInferrer.inferType(spec.getValue());
            if (result.getType() == null || !this.typeSystem.isIntegerType(result.getType())) {
                this.error("The evaluation result of a time expression must be of type integer", null);
            }
            this.report(result, (EStructuralFeature)StextPackage.Literals.TIME_EVENT_SPEC__VALUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Check(value=CheckType.FAST)
    public void checkReactionTrigger(ReactionTrigger reactionTrigger) {
        for (EventSpec eventSpec : reactionTrigger.getTriggers()) {
            if (reactionTrigger.eContainer() instanceof LocalReaction || !(eventSpec instanceof EntryEvent) && !(eventSpec instanceof ExitEvent)) continue;
            this.error("entry and exit events are allowed as local reactions only.", (EStructuralFeature)StextPackage.Literals.REACTION_TRIGGER__TRIGGERS, -1, "Local reactions not allowed", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkReactionEffectActionExpression(ReactionEffect effect) {
        EList<Expression> actions = effect.getActions();
        for (Expression expression : actions) {
            try {
                this.report(this.typeInferrer.inferType(expression), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Check(value=CheckType.FAST)
    public void checkReactionEffectActions(ReactionEffect effect) {
        for (Expression exp : effect.getActions()) {
            if (exp instanceof AssignmentExpression || exp instanceof EventRaisingExpression) continue;
            if (exp instanceof FeatureCall) {
                this.checkFeatureCallEffect((FeatureCall)exp);
                continue;
            }
            if (exp instanceof ElementReferenceExpression) {
                this.checkElementReferenceEffect((ElementReferenceExpression)exp);
                continue;
            }
            this.error("Action has no effect.", (EStructuralFeature)StextPackage.Literals.REACTION_EFFECT__ACTIONS, effect.getActions().indexOf((Object)exp), "FeatureCall has no effect", new String[0]);
        }
    }

    protected void checkFeatureCallEffect(FeatureCall call) {
        if (call.getFeature() != null && call.getFeature() instanceof Feature && !(call.getFeature() instanceof Operation)) {
            if (call.getFeature() instanceof Property) {
                this.error("Access to property '" + this.nameProvider.getFullyQualifiedName(call.getFeature()) + "' has no effect.", (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, "FeatureCall has no effect", new String[0]);
            } else if (call.getFeature() instanceof Event) {
                this.error("Access to event '" + this.nameProvider.getFullyQualifiedName(call.getFeature()) + "' has no effect.", (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, "FeatureCall has no effect", new String[0]);
            } else {
                this.error("Access to feature '" + this.nameProvider.getFullyQualifiedName(call.getFeature()) + "' has no effect.", (EObject)call, (EStructuralFeature)ExpressionsPackage.Literals.FEATURE_CALL__FEATURE, -1, "FeatureCall has no effect", new String[0]);
            }
        }
    }

    protected void checkElementReferenceEffect(ElementReferenceExpression refExp) {
        if (!(refExp.getReference() instanceof Operation)) {
            if (refExp.getReference() instanceof Property) {
                this.error("Access to property '" + this.nameProvider.getFullyQualifiedName(refExp.getReference()) + "' has no effect.", (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, "FeatureCall has no effect", new String[0]);
            } else if (refExp.getReference() instanceof Event) {
                this.error("Access to event '" + this.nameProvider.getFullyQualifiedName(refExp.getReference()) + "' has no effect.", (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, "FeatureCall has no effect", new String[0]);
            } else {
                this.error("Access to feature '" + this.nameProvider.getFullyQualifiedName(refExp.getReference()) + "' has no effect.", (EObject)refExp, (EStructuralFeature)ExpressionsPackage.Literals.ELEMENT_REFERENCE_EXPRESSION__REFERENCE, -1, "FeatureCall has no effect", new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEventDefinition(EventDefinition event) {
        if (event.eContainer() instanceof InterfaceScope && event.getDirection() == Direction.LOCAL) {
            this.error("Local declarations are not allowed in interface scope.", (EStructuralFeature)StextPackage.Literals.EVENT_DEFINITION__DIRECTION);
        }
        if (event.eContainer() instanceof InternalScope && event.getDirection() != Direction.LOCAL) {
            this.error("In/Out declarations are not allowed in internal scope.", (EStructuralFeature)StextPackage.Literals.EVENT_DEFINITION__DIRECTION);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkExitPointSpecWithTrigger(Transition t) {
        if (!STextValidationModelUtils.getExitPointSpecs((List<ReactionProperty>)t.getProperties()).isEmpty() && t.getTrigger() != null && t.getSource() instanceof State) {
            this.error("Transitions with an exit point spec does not have a trigger or guard.", (EObject)t, null, -1);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkInterfaceScope(ScopedElement statechart) {
        LinkedList<InterfaceScope> defaultInterfaces = new LinkedList<InterfaceScope>();
        for (Scope scope : statechart.getScopes()) {
            if (!(scope instanceof InterfaceScope) || ((InterfaceScope)scope).getName() != null) continue;
            defaultInterfaces.add((InterfaceScope)scope);
        }
        if (defaultInterfaces.size() > 1) {
            for (InterfaceScope interfaceScope : defaultInterfaces) {
                this.error("Only one default/unnamed interface is allowed.", (EObject)interfaceScope, this.grammarAccess.getInterfaceScopeAccess().getInterfaceKeyword_1(), -1, "Only one default/unnamed interface is allowed.");
            }
        }
    }

    @Check
    public void checkChoiceWithoutDefaultTransition(Choice choice) {
        boolean found = false;
        for (Transition transition : choice.getOutgoingTransitions()) {
            Trigger trigger = transition.getTrigger();
            if (!this.isDefault(trigger)) continue;
            found = true;
        }
        if (!found) {
            this.warning("A choice should have one outgoing default transition", (EStructuralFeature)SGraphPackage.Literals.VERTEX__OUTGOING_TRANSITIONS);
        }
    }

    protected boolean isDefault(Trigger trigger) {
        return trigger == null || trigger instanceof DefaultTrigger || trigger instanceof ReactionTrigger && ((ReactionTrigger)trigger).getTriggers().size() == 0 && ((ReactionTrigger)trigger).getGuard() == null;
    }

    protected String getCurrentLanguage(Map<Object, Object> context, EObject eObject) {
        Resource eResource = eObject.eResource();
        if (eResource instanceof XtextResource) {
            return super.getCurrentLanguage(context, eObject);
        }
        if (eResource instanceof AbstractSCTResource) {
            return ((AbstractSCTResource)eResource).getLanguageName();
        }
        return "";
    }

    protected void error(String message, EObject source, Keyword keyword, int index, String code) {
        INode child;
        String[] issueData = null;
        ICompositeNode rootNode = NodeModelUtils.findActualNodeFor((EObject)source);
        if (rootNode != null && (child = this.findNode(source, false, (INode)rootNode, keyword, new int[]{index})) != null) {
            int offset = child.getTotalOffset();
            int length = child.getTotalLength();
            this.getMessageAcceptor().acceptError(message, source, offset, length, code, issueData);
            return;
        }
        this.error(message, source, null, -1, code, new String[0]);
    }

    private INode findNode(EObject source, boolean sourceFound, INode root, Keyword keyword, int[] index) {
        EObject grammarElement;
        if (sourceFound && root.getSemanticElement() != source) {
            return null;
        }
        if (root.getSemanticElement() == source) {
            sourceFound = true;
        }
        if ((grammarElement = root.getGrammarElement()) instanceof Keyword && keyword.getValue().equals(((Keyword)grammarElement).getValue())) {
            if (index[0] != -1) {
                index[0] = index[0] - 1;
            }
            if (index[0] == 0 || index[0] == -1) {
                return root;
            }
        }
        if (root instanceof ICompositeNode) {
            ICompositeNode node = (ICompositeNode)root;
            for (INode child : node.getChildren()) {
                INode result = this.findNode(source, sourceFound, child, keyword, index);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    protected List<EPackage> getEPackages() {
        List<EPackage> result = super.getEPackages();
        result.add((EPackage)ExpressionsPackage.eINSTANCE);
        return result;
    }

    @Check(value=CheckType.FAST)
    public void checkImportExists(Import importDef) {
        String importedNamespace = importDef.getImportedNamespace();
        if (!this.checkImportedNamespaceExists(importDef.getImportedNamespace(), this.getResource(importDef))) {
            this.error("The import " + importedNamespace + " cannot be resolved", importDef, (EStructuralFeature)StextPackage.Literals.IMPORT__IMPORTED_NAMESPACE, "Import cannot be resolved", new String[0]);
        }
    }

    protected boolean checkImportedNamespaceExists(String importedNamespace, Resource res) {
        URI uri;
        IResourceDescriptions resourceDescriptions;
        IResourceDescription resourceDescription;
        if (importedNamespace.endsWith(".*")) {
            importedNamespace = importedNamespace.substring(0, importedNamespace.length() - 2);
        }
        if ((resourceDescription = (resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(res)).getResourceDescription(uri = res.getURI())) == null) {
            return false;
        }
        for (IContainer container : this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions)) {
            Iterable currentDescriptions = container.getResourceDescriptions();
            for (IResourceDescription resDesc : currentDescriptions) {
                Iterable visiblePackages = resDesc.getExportedObjectsByType(TypesPackage.Literals.PACKAGE);
                for (IEObjectDescription pkgDesc : visiblePackages) {
                    if (!pkgDesc.getName().toString().equals(importedNamespace)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Resource getResource(EObject context) {
        ContextElementAdapter provider = (ContextElementAdapter)EcoreUtil.getExistingAdapter((Notifier)context.eResource(), ContextElementAdapter.class);
        if (provider == null) {
            return context.eResource();
        }
        return provider.getElement().eResource();
    }
}

