/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.scoping;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.yakindu.base.expressions.expressions.ExpressionsPackage;
import org.yakindu.base.types.TypesPackage;
import org.yakindu.sct.model.stext.stext.StextPackage;

public class ContextPredicateProvider {
    public static final String IS_COMPLEX_TYPE = "IS_COMPLEX_TYPE";
    private static final EmptyPredicate EMPTY_PREDICATE = new EmptyPredicate();
    private static final VariablePredicate VARIABLES = new VariablePredicate();
    private static final EventPredicate EVENTS = new EventPredicate();
    private static final VariableOperationPredicate VARIABLES_AND_OPERATIONS = new VariableOperationPredicate();
    private static final VariableOperationEventEnumeratorPredicate VARIABLES_OPERATIONS_EVENTS_ENUMERATORS = new VariableOperationEventEnumeratorPredicate();
    private static final TypePredicate TYPES = new TypePredicate();
    private static final Predicate<IEObjectDescription> ALL = Predicates.alwaysTrue();
    private final Map<Pair<EClass, EReference>, Predicate<IEObjectDescription>> filter = new HashMap<Pair<EClass, EReference>, Predicate<IEObjectDescription>>();

    public ContextPredicateProvider() {
        this.initMap();
    }

    private Pair<EClass, EReference> key(EClass eClass) {
        return Tuples.create((Object)eClass, null);
    }

    private Pair<EClass, EReference> key(EClass eClass, EReference ref) {
        return Tuples.create((Object)eClass, (Object)ref);
    }

    protected void initMap() {
        this.filter.put(this.key(ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION, ExpressionsPackage.Literals.ASSIGNMENT_EXPRESSION__EXPRESSION), ALL);
        this.filter.put(this.key(ExpressionsPackage.Literals.CONDITIONAL_EXPRESSION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_OR_EXPRESSION), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_AND_EXPRESSION), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_NOT_EXPRESSION), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_XOR_EXPRESSION), VARIABLES);
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_OR_EXPRESSION), VARIABLES);
        this.filter.put(this.key(ExpressionsPackage.Literals.BITWISE_AND_EXPRESSION), VARIABLES);
        this.filter.put(this.key(ExpressionsPackage.Literals.SHIFT_EXPRESSION), VARIABLES);
        this.filter.put(this.key(ExpressionsPackage.Literals.LOGICAL_RELATION_EXPRESSION), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_ADD_SUBTRACT_EXPRESSION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_MULTIPLY_DIVIDE_EXPRESSION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(ExpressionsPackage.Literals.NUMERICAL_UNARY_EXPRESSION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(StextPackage.Literals.EVENT_RAISING_EXPRESSION), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.EVENT_RAISING_EXPRESSION, StextPackage.Literals.EVENT_RAISING_EXPRESSION__VALUE), VARIABLES_OPERATIONS_EVENTS_ENUMERATORS);
        this.filter.put(this.key(StextPackage.Literals.REGULAR_EVENT_SPEC), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.EVENT_VALUE_REFERENCE_EXPRESSION), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.REACTION_EFFECT), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(StextPackage.Literals.TRANSITION_SPECIFICATION), EVENTS);
        this.filter.put(this.key(StextPackage.Literals.LOCAL_REACTION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(StextPackage.Literals.TRANSITION_REACTION), VARIABLES_AND_OPERATIONS);
        this.filter.put(this.key(StextPackage.Literals.VARIABLE_DEFINITION, TypesPackage.Literals.TYPED_ELEMENT__TYPE), TYPES);
    }

    public Predicate<IEObjectDescription> getPredicate(EClass clazz, EReference reference) {
        Predicate<IEObjectDescription> predicate = this.filter.get(this.key(clazz, reference));
        if (predicate == null && (predicate = this.filter.get(this.key(clazz, null))) == null) {
            return EMPTY_PREDICATE;
        }
        return predicate;
    }

    static class EmptyPredicate
    implements Predicate<IEObjectDescription> {
        EmptyPredicate() {
        }

        public boolean apply(IEObjectDescription input) {
            return true;
        }
    }

    static class EventPredicate
    extends FeaturedTypePredicate {
        EventPredicate() {
        }

        @Override
        public boolean apply(IEObjectDescription input) {
            if (super.apply(input)) {
                return true;
            }
            return TypesPackage.Literals.EVENT.isSuperTypeOf(input.getEClass()) || this.isComplexTypeVariable(input);
        }

        protected boolean isComplexTypeVariable(IEObjectDescription input) {
            if (StextPackage.Literals.VARIABLE_DEFINITION.isSuperTypeOf(input.getEClass())) {
                return Boolean.parseBoolean(input.getUserData(ContextPredicateProvider.IS_COMPLEX_TYPE));
            }
            return false;
        }
    }

    static class FeaturedTypePredicate
    implements Predicate<IEObjectDescription> {
        FeaturedTypePredicate() {
        }

        public boolean apply(IEObjectDescription input) {
            return TypesPackage.Literals.TYPE.isSuperTypeOf(input.getEClass()) && TypesPackage.Literals.FEATURE.isSuperTypeOf(input.getEClass());
        }
    }

    static class TypePredicate
    implements Predicate<IEObjectDescription> {
        TypePredicate() {
        }

        public boolean apply(IEObjectDescription input) {
            return TypesPackage.Literals.TYPE.isSuperTypeOf(input.getEClass()) && !TypesPackage.Literals.TYPE_PARAMETER.isSuperTypeOf(input.getEClass());
        }
    }

    static class VariableOperationEventEnumeratorPredicate
    extends FeaturedTypePredicate {
        VariableOperationEventEnumeratorPredicate() {
        }

        @Override
        public boolean apply(IEObjectDescription input) {
            if (super.apply(input)) {
                return true;
            }
            return TypesPackage.Literals.PROPERTY.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.OPERATION.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.EVENT.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.ENUMERATOR.isSuperTypeOf(input.getEClass());
        }
    }

    static class VariableOperationPredicate
    extends FeaturedTypePredicate {
        VariableOperationPredicate() {
        }

        @Override
        public boolean apply(IEObjectDescription input) {
            if (super.apply(input)) {
                return true;
            }
            return TypesPackage.Literals.PROPERTY.isSuperTypeOf(input.getEClass()) || TypesPackage.Literals.OPERATION.isSuperTypeOf(input.getEClass());
        }
    }

    static class VariablePredicate
    extends FeaturedTypePredicate {
        VariablePredicate() {
        }

        @Override
        public boolean apply(IEObjectDescription input) {
            if (super.apply(input)) {
                return true;
            }
            return TypesPackage.Literals.PROPERTY.isSuperTypeOf(input.getEClass());
        }
    }
}

