/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.plugin;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.file.ManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IBuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IManifestEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IPluginProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.PluginProjectEditor;
import org.xml.sax.SAXException;

public class PluginEditor
extends PluginProjectEditor
implements IPluginProjectEditor,
IManifestEditor,
IBuildEditor {
    protected IManifestEditor manifest;
    protected IBuildEditor build;

    public PluginEditor(IProject project) throws CoreException, IOException, SAXException, ParserConfigurationException {
        super(project);
        this.manifest = new ManifestEditor(project);
        this.build = new BuildEditor(project);
        this.manifest.init();
        this.build.init();
        if (!this.exists()) {
            this.create();
        }
        this.init();
    }

    public PluginProjectEditor getPluginEditor() {
        return this;
    }

    public IManifestEditor getManifestEditor() {
        return this.manifest;
    }

    public IBuildEditor getBuildEditor() {
        return this.build;
    }

    public void registerSourceFolder(String source) {
        this.build.registerSourceFolder(source);
    }

    public void addToBuild(String path) {
        this.build.addToBuild(path);
    }

    public String[] getSourceFolders() {
        return this.build.getSourceFolders();
    }

    public void addDependency(String dependency) {
        this.manifest.addDependency(dependency);
    }

    public void addDependency(String dependency, String version) {
        this.manifest.addDependency(dependency, version);
    }

    public void setValue(String key, String value) {
        this.manifest.setValue(key, value);
    }

    public void setValue(String key, String name, String value) {
        this.manifest.setValue(key, name, value);
    }

    public void removeValue(String key, String value) {
        this.manifest.removeValue(key, value);
    }

    public void removeValue(String key) {
        this.manifest.removeValue(key);
    }

    public void setBundleName(String name) {
        this.manifest.setBundleName(name);
    }

    public String getSymbolicBundleName() {
        return this.manifest.getSymbolicBundleName();
    }

    public String getBundleVersion() {
        return this.manifest.getBundleVersion();
    }

    public void setBundleVersion(String version) {
        this.manifest.setBundleVersion(version);
    }

    public void save() {
        super.save();
        this.manifest.save();
        this.build.save();
    }

    public void registerBinFolder(String binFolder) {
        this.build.registerBinFolder(binFolder);
    }

    public void removeFromBuild(String path) {
        this.build.removeFromBuild(path);
    }

    public boolean isRegisteredSourceFolder(String path) {
        return this.build.isRegisteredSourceFolder(path);
    }

    public boolean isRegisteredBinFolder(String binFolder) {
        return this.build.isRegisteredBinFolder(binFolder);
    }

    public String[] getElementsInBuild() {
        return this.build.getElementsInBuild();
    }

    public String getBundleVendor() {
        return this.manifest.getBundleVendor();
    }

    public void setBundleVendor(String vendor) {
        this.manifest.setBundleVendor(vendor);
    }

    public String getValue(String key) {
        return this.manifest.getValue(key);
    }

    public void setSymbolicBundleName(String name) {
        this.manifest.setSymbolicBundleName(name);
    }

    public String getBundleName() {
        return this.manifest.getBundleName();
    }

    public String getBundleLocalization() {
        return this.manifest.getBundleLocalization();
    }

    public void setSingleton(boolean singleton) {
        this.manifest.setSingleton(singleton);
    }

    public void setDependenciesVersion(String dependencyPattern, String newVersion) {
        this.manifest.setDependenciesVersion(dependencyPattern, newVersion);
    }
}

