/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.tools.internal.export.csv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.tools.internal.export.csv.TableFiller;

public final class TableCsvHelper {
    public static final char EOL_CHARACTER = '\n';
    private static short maxOffsetReached;

    private TableCsvHelper() {
    }

    public static Iterable<Iterable<String>> getTableDescriptor(DTable table) {
        TableFiller filler = new TableFiller(';', '|');
        ArrayList descriptors = Lists.newArrayList();
        descriptors.add(TableCsvHelper.getHeader(table, filler));
        maxOffsetReached = 0;
        for (DLine line : table.getLines()) {
            TableCsvHelper.addLineToDescriptor(line, descriptors, filler, (short)0);
        }
        return descriptors;
    }

    private static List<String> getHeader(DTable table, TableFiller filler) {
        ArrayList header = Lists.newArrayList();
        header.add("");
        for (DColumn column : table.getColumns()) {
            if (!column.isVisible()) continue;
            header.add(filler.getContent(column));
        }
        return header;
    }

    private static void addLineToDescriptor(DLine line, List<List<String>> descriptors, TableFiller filler, short baseOffset) {
        if (line.isVisible()) {
            int i;
            ArrayList lineCellValues = Lists.newArrayList();
            if (baseOffset > 0) {
                i = 0;
                while (i < baseOffset) {
                    lineCellValues.add("");
                    ++i;
                }
            }
            lineCellValues.add(filler.getContent(line));
            i = baseOffset;
            while (i < maxOffsetReached) {
                lineCellValues.add("");
                ++i;
            }
            for (DColumn column : TableHelper.getTable(line).getColumns()) {
                if (!column.isVisible()) continue;
                Option<DCell> optionalCell = TableHelper.getCell(line, column);
                if (optionalCell.some()) {
                    lineCellValues.add(filler.getContent((DCell)optionalCell.get()));
                    continue;
                }
                lineCellValues.add("");
            }
            descriptors.add(lineCellValues);
            EList<DLine> subLines = line.getLines();
            short offset = baseOffset;
            if (!subLines.isEmpty() && (offset = (short)((short)(offset + 1))) > maxOffsetReached) {
                for (List<String> descriptorLine : descriptors) {
                    descriptorLine.add(offset, "");
                }
                maxOffsetReached = offset;
            }
            for (DLine subLine : subLines) {
                TableCsvHelper.addLineToDescriptor(subLine, descriptors, filler, offset);
            }
            if (!subLines.isEmpty()) {
                offset = (short)(offset - 1);
            }
        }
    }
}

