/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.metamodel.spec;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DTableElementSynchronizer;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.impl.DLineImpl;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class DLineSpec
extends DLineImpl {
    private Adapter targetListener;

    @Override
    public void activate(DTableElementSynchronizer sync) {
        for (EObject semantic : this.getSemanticElements()) {
            semantic.eAdapters().add((Object)this.getOrCreateListener(sync));
        }
        if (this.getTarget() != null && !this.getSemanticElements().contains((Object)this.getTarget())) {
            this.getTarget().eAdapters().add((Object)this.getOrCreateListener(sync));
        }
    }

    @Override
    public void deactivate() {
        if (this.targetListener != null) {
            for (EObject semantic : this.getSemanticElements()) {
                semantic.eAdapters().remove((Object)this.targetListener);
            }
            if (this.getTarget() != null && !this.getSemanticElements().contains((Object)this.getTarget())) {
                this.getTarget().eAdapters().remove((Object)this.targetListener);
            }
        }
        this.targetListener = null;
    }

    private Adapter getOrCreateListener(final DTableElementSynchronizer sync) {
        if (this.targetListener == null) {
            this.targetListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() != 8 && !Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null)) {
                        sync.refresh(DLineSpec.this);
                    }
                }
            };
        }
        return this.targetListener;
    }

    @Override
    public EList<DCell> getOrderedCells() {
        final HashMap columnIndices = Maps.newHashMap();
        int i = 0;
        for (DColumn col : TableHelper.getTable(this).getColumns()) {
            columnIndices.put(col, i++);
        }
        Ordering ordering = Ordering.from((Comparator)new Comparator<DCell>(){

            @Override
            public int compare(DCell a, DCell b) {
                int result = 0;
                DColumn columnA = a.getColumn();
                DColumn columnB = b.getColumn();
                if (columnA == null || columnA.eContainer() == null) {
                    result = -1;
                } else if (columnB == null || columnB.eContainer() == null) {
                    result = 1;
                } else {
                    Integer aIndex = (Integer)columnIndices.get(columnA);
                    Integer bIndex = (Integer)columnIndices.get(columnB);
                    if (aIndex == null || bIndex == null) {
                        throw new RuntimeException("Should not happen.");
                    }
                    return aIndex - bIndex;
                }
                return result;
            }
        });
        Object[] data = new DCell[this.getCells().size()];
        this.getCells().toArray(data);
        Arrays.sort(data, ordering);
        return new EcoreEList.UnmodifiableEList(this.eInternalContainer(), (EStructuralFeature)TablePackage.eINSTANCE.getDLine_OrderedCells(), data.length, data);
    }

    @Override
    public RepresentationElementMapping getMapping() {
        return this.getOriginMapping();
    }

    @Override
    public TableMapping basicGetTableElementMapping() {
        return (TableMapping)this.getMapping();
    }

    @Override
    public TableMapping getTableElementMapping() {
        TableMapping tableElementMapping = this.basicGetTableElementMapping();
        return tableElementMapping != null && tableElementMapping.eIsProxy() ? (TableMapping)this.eResolveProxy((InternalEObject)tableElementMapping) : tableElementMapping;
    }
}

