/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.metamodel.spec;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.table.metamodel.table.DTableElementSynchronizer;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.StyleUpdater;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.impl.DCellImpl;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

public class DCellSpec
extends DCellImpl {
    private Adapter targetListener;

    @Override
    public void activate(DTableElementSynchronizer sync) {
        for (EObject semantic : this.getSemanticElements()) {
            semantic.eAdapters().add((Object)this.getOrCreateListener(sync));
        }
        if (this.getTarget() != null && !this.getSemanticElements().contains((Object)this.getTarget())) {
            this.getTarget().eAdapters().add((Object)this.getOrCreateListener(sync));
        }
    }

    private Adapter getOrCreateListener(final DTableElementSynchronizer sync) {
        if (this.targetListener == null) {
            this.targetListener = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() != 8 && !Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null)) {
                        sync.refresh(DCellSpec.this);
                    }
                }
            };
        }
        return this.targetListener;
    }

    @Override
    public void deactivate() {
        if (this.targetListener != null) {
            for (EObject semantic : this.getSemanticElements()) {
                semantic.eAdapters().remove((Object)this.targetListener);
            }
            if (this.getTarget() != null && !this.getSemanticElements().contains((Object)this.getTarget())) {
                this.getTarget().eAdapters().remove((Object)this.targetListener);
            }
        }
        this.targetListener = null;
    }

    @Override
    public CellUpdater basicGetUpdater() {
        CellUpdater updater = null;
        if (this.getColumn() != null && this.getColumn().getOriginMapping() instanceof CellUpdater) {
            updater = (CellUpdater)((Object)this.getColumn().getOriginMapping());
        }
        if (this.getIntersectionMapping() != null) {
            updater = this.getIntersectionMapping();
        }
        return updater;
    }

    @Override
    public RepresentationElementMapping getMapping() {
        StyleUpdater result = null;
        CellUpdater cellUpdater = this.getUpdater();
        if (cellUpdater instanceof FeatureColumnMapping) {
            result = (FeatureColumnMapping)cellUpdater;
        } else if (cellUpdater instanceof IntersectionMapping) {
            result = (IntersectionMapping)cellUpdater;
        }
        return result;
    }

    @Override
    public TableMapping getTableElementMapping() {
        TableMapping tableElementMapping = this.basicGetTableElementMapping();
        return tableElementMapping != null && tableElementMapping.eIsProxy() ? (TableMapping)this.eResolveProxy((InternalEObject)tableElementMapping) : tableElementMapping;
    }

    @Override
    public TableMapping basicGetTableElementMapping() {
        return (TableMapping)this.getMapping();
    }

    @Override
    public CellUpdater getUpdater() {
        CellUpdater updater = this.basicGetUpdater();
        return updater != null && updater.eIsProxy() ? (CellUpdater)this.eResolveProxy((InternalEObject)updater) : updater;
    }
}

